/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.client.particle.animation;

import java.util.function.BiConsumer;
import java.util.function.Predicate;
import net.kapitencraft.kap_lib.client.particle.animation.ParticleAnimParam;
import net.kapitencraft.kap_lib.client.particle.animation.ParticleAnimParams;
import net.kapitencraft.kap_lib.client.particle.animation.ParticleAnimationParameters;
import net.kapitencraft.kap_lib.client.particle.animation.ParticleMoveControl;
import net.kapitencraft.kap_lib.helpers.MathHelper;
import net.minecraft.client.particle.Particle;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;

public enum ParticleAnimations implements Predicate<ParticleAnimationParameters>,
BiConsumer<Particle, ParticleAnimationParameters>
{
    MOVE_AWAY(ParticleAnimParams.SOURCE),
    MOVE_TO(ParticleAnimParams.TARGET),
    MOVE(ParticleAnimParams.DELTA),
    ROTATE(ParticleAnimParams.SOURCE, ParticleAnimParams.ROTATION);

    private final ParticleAnimParam<?>[] requiredParams;

    private ParticleAnimations(ParticleAnimParam<?> ... requiredParams) {
        this.requiredParams = requiredParams;
    }

    @Override
    public boolean test(ParticleAnimationParameters particleAnimationContext) {
        return particleAnimationContext.containsAll(this.requiredParams);
    }

    @Override
    public void accept(Particle particle, ParticleAnimationParameters params) {
        ParticleMoveControl control = ParticleMoveControl.fromParticle(particle);
        int remaining = params.remainingAnimTime;
        switch (this) {
            case MOVE: {
                Vec3 moveVec;
                control.deltaVec = moveVec = params.getParam(ParticleAnimParams.DELTA).orElse(Vec3.f_82478_);
                break;
            }
            case MOVE_TO: {
                int id = params.getParamOrThrow(ParticleAnimParams.TARGET);
                Entity entity = control.level.m_6815_(id);
                Vec3 move = control.loc.m_82546_(entity.m_20182_());
                control.deltaVec = control.loc.m_82549_(move.m_82490_(move.m_82553_() / (double)remaining));
                break;
            }
            case MOVE_AWAY: {
                int id = params.getParamOrThrow(ParticleAnimParams.SOURCE);
                Entity entity = control.level.m_6815_(id);
                Vec3 move = entity.m_20182_().m_82546_(control.loc);
                control.deltaVec = move.m_82490_((double)(remaining * 5));
                break;
            }
            case ROTATE: {
                int id = params.getParamOrThrow(ParticleAnimParams.SOURCE);
                Entity entity = control.level.m_6815_(id);
                int rot = params.getParamOrThrow(ParticleAnimParams.ROTATION);
                Vec3 outRot = MathHelper.calculateViewVector(0.0f, rot);
                Vec3 vec3 = entity.m_20182_().m_82546_(control.loc);
            }
        }
        double particleSpeed = new Vec3(particle.f_107215_, particle.f_107216_, particle.f_107217_).m_82553_();
        control.deltaVec = MathHelper.maximiseLength(control.deltaVec, particleSpeed);
        control.applyToParticle(particle);
    }
}

