/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.collection;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import net.kapitencraft.kap_lib.helpers.CollectionHelper;
import net.kapitencraft.kap_lib.stream.Consumers;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class DoubleMap<MK, K, V>
extends HashMap<MK, Map<K, V>> {
    private boolean immutable = false;

    public void forValues(Consumer<V> consumer) {
        this.values().stream().map(Map::values).flatMap(Collection::stream).forEach(consumer);
    }

    public static <T, K, L> DoubleMap<T, K, L> of(Map<T, Map<K, L>> map) {
        DoubleMap<T, T, L> map1 = DoubleMap.create();
        map1.putAll(map);
        return map1;
    }

    public Map<K, V> getOrCreate(MK element) {
        if (this.get(element) == null) {
            this.put(element, new HashMap());
        }
        return (Map)this.get(element);
    }

    public Collection<V> actualValues() {
        return CollectionHelper.values(this);
    }

    @Override
    public Map<K, V> put(MK key, Map<K, V> value) {
        if (this.immutable) {
            throw new UnsupportedOperationException("tried modifying immutable double map");
        }
        return super.put(key, value);
    }

    public DoubleMap<MK, K, V> immutable() {
        this.immutable = true;
        return this;
    }

    public void forMap(BiConsumer<K, V> biConsumer) {
        this.values().forEach((? super T map) -> map.forEach(biConsumer));
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <T, K, L> DoubleMap<T, K, L> create() {
        return new DoubleMap();
    }

    public void put(MK MK, K k, V v) {
        if (this.immutable) {
            throw new UnsupportedOperationException("tried modifying immutable double map");
        }
        if (this.containsKey(MK)) {
            ((Map)this.get(MK)).put(k, v);
        } else {
            HashMap<K, V> map = new HashMap<K, V>();
            map.put(k, v);
            this.put(MK, map);
        }
    }

    public V putIfAbsent(MK mk, K k, V ifAbsent) {
        if (this.immutable) {
            throw new UnsupportedOperationException("tried modifying immutable double map");
        }
        if (this.containsKey(mk)) {
            ((Map)this.get(mk)).putIfAbsent(k, ifAbsent);
        } else {
            this.put(mk, new HashMap());
            ((Map)this.get(mk)).put(k, ifAbsent);
        }
        return this.get(mk, k);
    }

    public V get(MK MK, K k) {
        return ((Map)this.get(MK)).get(k);
    }

    public V getOrNull(MK MK, K k) {
        try {
            return this.get(MK, k);
        }
        catch (Exception e) {
            return null;
        }
    }

    public V computeIfAbsent(MK mk, K k, BiFunction<MK, K, V> mapper) {
        return this.putIfAbsent(mk, k, mapper.apply(mk, k));
    }

    public void forAllEach(Consumers.C3<MK, K, V> consumer) {
        this.forEach((mk, kvMap) -> kvMap.forEach((k, v) -> consumer.apply(mk, k, v)));
    }
}

