/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.data_gen.abst;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import net.kapitencraft.kap_lib.KapLibMod;
import net.kapitencraft.kap_lib.collection.DoubleMap;
import net.kapitencraft.kap_lib.collection.MapStream;
import net.kapitencraft.kap_lib.io.serialization.DataGenSerializer;
import net.kapitencraft.kap_lib.item.bonus.Bonus;
import net.kapitencraft.kap_lib.item.bonus.BonusManager;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.tags.TagsProvider;
import net.minecraft.tags.TagBuilder;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.Item;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public abstract class BonusProvider
implements DataProvider {
    private final PackOutput output;
    private final String modId;
    private final Map<String, SetBuilder> setBuilders = new HashMap<String, SetBuilder>();
    private final DoubleMap<Item, String, ItemBuilder> itemBuilders = DoubleMap.create();

    public BonusProvider(PackOutput output, String modId) {
        this.output = output;
        this.modId = modId;
    }

    protected SetBuilder createSetBonus(String name) {
        this.setBuilders.putIfAbsent(name, new SetBuilder());
        return this.setBuilders.get(name);
    }

    protected ItemBuilder createItemBonus(Item item, String path) {
        ItemBuilder builder = new ItemBuilder();
        this.itemBuilders.putIfAbsent(item, path, builder);
        return builder;
    }

    public abstract void register();

    protected SlotBuilder simpleItem(Item item) {
        return new SlotBuilder().add(item);
    }

    protected SlotBuilder createBuilder() {
        return new SlotBuilder();
    }

    @NotNull
    public CompletableFuture<?> m_213708_(@NotNull CachedOutput pOutput) {
        this.register();
        List<CompletableFuture> setExecutors = MapStream.of(this.setBuilders).mapToSimple((key, builder) -> {
            Path path = this.output.m_247566_(PackOutput.Target.DATA_PACK).resolve(this.modId).resolve("bonuses").resolve("set").resolve(key + ".json");
            return DataProvider.m_253162_((CachedOutput)pOutput, (JsonElement)this.saveSet((SetBuilder)builder), (Path)path);
        }).toList();
        ArrayList itemExecutors = new ArrayList();
        this.itemBuilders.forAllEach((item, location, itemBuilder) -> {
            Path path = this.output.m_247566_(PackOutput.Target.DATA_PACK).resolve(this.modId).resolve("bonuses").resolve(location + ".json");
            itemExecutors.add(DataProvider.m_253162_((CachedOutput)pOutput, (JsonElement)this.saveItem((Item)item, (ItemBuilder)itemBuilder), (Path)path));
        });
        return CompletableFuture.allOf(CompletableFuture.allOf((CompletableFuture[])setExecutors.toArray(CompletableFuture[]::new)), CompletableFuture.allOf((CompletableFuture[])itemExecutors.toArray(CompletableFuture[]::new)));
    }

    private <T extends Bonus<T>> JsonObject saveItem(Item item, ItemBuilder itemBuilder) {
        Bonus<?> bonus = itemBuilder.getBonus();
        JsonObject main = new JsonObject();
        if (itemBuilder.isHidden()) {
            main.addProperty("hidden", Boolean.valueOf(true));
        }
        DataGenSerializer<?> serializer = bonus.getSerializer();
        main.add("data", (JsonElement)serializer.serialize(bonus));
        if (item != null) {
            main.addProperty("item", Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)item), "unknown item with class: " + item.getClass().getCanonicalName()).toString());
        }
        return main;
    }

    private <T extends Bonus<T>> JsonObject saveSet(SetBuilder builder) {
        Bonus<?> bonus = builder.getBonus();
        JsonObject main = this.saveItem(null, builder);
        JsonObject items = new JsonObject();
        for (EquipmentSlot slot : builder.content.keySet()) {
            JsonElement element = (JsonElement)BonusManager.TAG_ENTRY_LOADER_CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)builder.content.get(slot).getInternalBuilder().m_215904_()).getOrThrow(false, arg_0 -> ((Logger)KapLibMod.LOGGER).error(arg_0));
            items.add(slot.m_20751_(), element);
        }
        main.add("items", (JsonElement)items);
        return main;
    }

    @NotNull
    public String m_6055_() {
        return "Sets of '" + this.modId + "'";
    }

    protected class SetBuilder
    extends ItemBuilder {
        private final Map<EquipmentSlot, SlotBuilder> content = new HashMap<EquipmentSlot, SlotBuilder>();

        protected SetBuilder() {
        }

        public SetBuilder slot(EquipmentSlot slot, SlotBuilder builder) {
            this.content.putIfAbsent(slot, builder);
            return this;
        }

        @Override
        public SetBuilder setHidden() {
            return (SetBuilder)super.setHidden();
        }

        @Override
        public SetBuilder setBonus(Bonus<?> bonus) {
            return (SetBuilder)super.setBonus(bonus);
        }

        private Map<EquipmentSlot, SlotBuilder> getContent() {
            return this.content;
        }
    }

    protected static class ItemBuilder {
        private Bonus<?> bonus;
        private boolean hidden;
        private String translationKey;

        protected ItemBuilder() {
        }

        public ItemBuilder setHidden() {
            this.hidden = true;
            return this;
        }

        public ItemBuilder setBonus(Bonus<?> bonus) {
            this.bonus = bonus;
            return this;
        }

        public boolean isHidden() {
            return this.hidden;
        }

        protected Bonus<?> getBonus() {
            return Objects.requireNonNull(this.bonus, "found builder without bonus!");
        }
    }

    protected class SlotBuilder
    extends TagsProvider.TagAppender<Item> {
        protected SlotBuilder() {
            super(new TagBuilder(), BonusProvider.this.modId);
        }

        public SlotBuilder add(Item item) {
            super.m_255204_(item.m_204114_().m_205785_());
            return this;
        }

        public SlotBuilder addAll(Item ... items) {
            for (Item item : items) {
                this.add(item);
            }
            return this;
        }

        @NotNull
        public SlotBuilder addTag(@NotNull TagKey<Item> tagKey) {
            super.m_206428_(tagKey);
            return this;
        }
    }
}

