/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.enchantments.extras;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.kapitencraft.kap_lib.enchantments.abstracts.ModEnchantment;
import net.kapitencraft.kap_lib.helpers.ClientHelper;
import net.kapitencraft.kap_lib.helpers.TextHelper;
import net.kapitencraft.kap_lib.requirements.RequirementType;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber
public class EnchantmentDescriptionManager {
    public static void addAllTooltips(ItemStack stack, List<Component> tooltips, ListTag pStoredEnchantments, Player player) {
        if (pStoredEnchantments.isEmpty()) {
            return;
        }
        if (!Screen.m_96638_()) {
            tooltips.add((Component)Component.m_237115_((String)"ench_desc.shift").m_130940_(ChatFormatting.DARK_GRAY));
        }
        for (int i = 0; i < pStoredEnchantments.size(); ++i) {
            CompoundTag compoundtag = pStoredEnchantments.m_128728_(i);
            Optional.ofNullable((Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(EnchantmentHelper.m_182446_((CompoundTag)compoundtag))).ifPresent(ench -> {
                tooltips.add(ench.m_44700_(EnchantmentHelper.m_182438_((CompoundTag)compoundtag)));
                if (Screen.m_96638_()) {
                    EnchantmentDescriptionManager.addTooltipForEnchant(stack, tooltips, ench, player);
                }
                ClientHelper.addReqContent(tooltips::add, RequirementType.ENCHANTMENT, ench, (LivingEntity)player);
            });
        }
    }

    public static void addTooltipForEnchant(ItemStack stack, List<Component> list, Enchantment enchantment, Player player) {
        List<Component> description;
        if (EnchantmentDescriptionManager.fromBook(stack.m_41720_())) {
            if (!enchantment.m_6594_()) {
                list.add((Component)Component.m_237115_((String)"ench_desc.not_tradeable").m_130940_(ChatFormatting.YELLOW));
            }
            if (enchantment.m_6591_()) {
                list.add((Component)Component.m_237115_((String)"ench_desc.treasure").m_130940_(ChatFormatting.YELLOW));
            }
        }
        if ((description = EnchantmentDescriptionManager.getDescription(stack, enchantment)).isEmpty()) {
            list.add((Component)Component.m_237115_((String)"ench_desc.missing").m_130940_(ChatFormatting.DARK_GRAY));
        } else {
            list.addAll(description);
        }
    }

    public static boolean fromBook(Item item) {
        return item instanceof EnchantedBookItem;
    }

    public static List<Component> getDescription(ItemStack stack, Enchantment ench) {
        Object[] objectArray;
        int level;
        int n = level = stack.m_41720_() instanceof EnchantedBookItem ? (Integer)EnchantmentHelper.m_44882_((ListTag)EnchantedBookItem.m_41163_((ItemStack)stack)).get(ench) : EnchantmentHelper.getTagEnchantmentLevel((Enchantment)ench, (ItemStack)stack);
        if (ench instanceof ModEnchantment) {
            ModEnchantment modEnchantment = (ModEnchantment)ench;
            objectArray = modEnchantment.getDescriptionMods(level);
        } else {
            String[] stringArray = new String[1];
            objectArray = stringArray;
            stringArray[0] = String.valueOf(level);
        }
        Object[] objects = objectArray;
        Stream<String> stream = Arrays.stream(objects).map(String::valueOf);
        return TextHelper.getDescriptionList(ench.m_44704_(), component -> component.m_130940_(ChatFormatting.DARK_GRAY), stream.map(TextHelper::wrapInRed).toArray());
    }
}

