/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.event;

import java.util.List;
import net.kapitencraft.kap_lib.helpers.AttributeHelper;
import net.kapitencraft.kap_lib.helpers.ClientHelper;
import net.kapitencraft.kap_lib.helpers.MathHelper;
import net.kapitencraft.kap_lib.helpers.MiscHelper;
import net.kapitencraft.kap_lib.io.network.ModMessages;
import net.kapitencraft.kap_lib.io.network.S2C.SyncRequirementsPacket;
import net.kapitencraft.kap_lib.item.bonus.BonusManager;
import net.kapitencraft.kap_lib.registry.ModAttributes;
import net.kapitencraft.kap_lib.requirements.RequirementManager;
import net.kapitencraft.kap_lib.requirements.RequirementType;
import net.kapitencraft.kap_lib.util.DamageCounter;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.client.event.MovementInputUpdateEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class Events {
    private static final List<Class<? extends PlayerEvent>> dontCancel = List.of(EntityItemPickupEvent.class, ItemTooltipEvent.class, RenderPlayerEvent.Pre.class, RenderPlayerEvent.Post.class, PlayerEvent.LoadFromFile.class, PlayerEvent.NameFormat.class, PlayerEvent.TabListNameFormat.class, PlayerEvent.PlayerLoggedInEvent.class, PlayerEvent.PlayerLoggedOutEvent.class, MovementInputUpdateEvent.class);

    @SubscribeEvent
    public static void ensureReqsMet(PlayerEvent event) {
        if (!dontCancel.contains(event.getClass()) && !RequirementManager.meetsRequirementsFromEvent(event, EquipmentSlot.MAINHAND) && event.isCancelable()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void addRequirementListener(AddReloadListenerEvent event) {
        RequirementManager.instance = new RequirementManager();
        event.addListener((PreparableReloadListener)RequirementManager.instance);
        BonusManager.instance = new BonusManager(event.getRegistryAccess());
        event.addListener((PreparableReloadListener)BonusManager.instance);
    }

    @SubscribeEvent
    public static void playerLogIn(PlayerEvent.PlayerLoggedInEvent event) {
        Player player = event.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ModMessages.sendToClientPlayer(new SyncRequirementsPacket(RequirementManager.instance), serverPlayer);
        }
    }

    @SubscribeEvent
    public static void addReqDisplay(ItemTooltipEvent event) {
        ClientHelper.addReqContent(event.getToolTip()::add, RequirementType.ITEM, event.getItemStack().m_41720_(), (LivingEntity)event.getEntity());
    }

    @SubscribeEvent
    public static void healingDisplay(LivingHealEvent event) {
        if (event.getAmount() > 0.0f) {
            MiscHelper.createDamageIndicator(event.getEntity(), event.getAmount(), "heal");
        }
    }

    @SubscribeEvent
    public static void damageTick(LivingDamageEvent event) {
        LivingEntity attacked = event.getEntity();
        DamageSource source = event.getSource();
        boolean dodge = false;
        double dodgePercentage = AttributeHelper.getSaveAttributeValue((Attribute)ModAttributes.DODGE.get(), attacked);
        if (dodgePercentage > 0.0 && MathHelper.chance(dodgePercentage / 100.0, attacked) && !source.m_269533_(DamageTypeTags.f_268490_) && !source.m_269533_(DamageTypeTags.f_268549_) && !source.m_269533_(DamageTypeTags.f_268745_)) {
            dodge = true;
            event.setAmount(0.0f);
        }
        MiscHelper.createDamageIndicator(attacked, event.getAmount(), dodge ? "dodge" : source.m_19385_());
        DamageCounter.increaseDamage(event.getAmount());
    }
}

