/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.helpers;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import net.kapitencraft.kap_lib.helpers.CollectionHelper;
import net.kapitencraft.kap_lib.util.attribute.ChangingAttributeModifier;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraftforge.common.ForgeMod;

public interface AttributeHelper {
    public static final HashMap<String, UUID> modUUIDs = new HashMap();
    public static final HashMap<EquipmentSlot, HashMap<String, UUID>> slotModUUIDs = new HashMap();

    public static Multimap<Attribute, AttributeModifier> increaseByPercent(Multimap<Attribute, AttributeModifier> multimap, double percent, AttributeModifier.Operation[] operations, @Nullable Attribute attributeReq) {
        HashMultimap toReturn = HashMultimap.create();
        for (Attribute attribute : multimap.keys()) {
            Collection attributeModifiers;
            if (attributeReq == null || attribute == attributeReq) {
                attributeModifiers = multimap.get((Object)attribute);
                for (AttributeModifier modifier : attributeModifiers) {
                    if (CollectionHelper.arrayContains(operations, modifier.m_22217_())) {
                        toReturn.put((Object)attribute, (Object)AttributeHelper.copyWithValue(modifier, modifier.m_22218_() * (1.0 + percent)));
                        continue;
                    }
                    toReturn.put((Object)attribute, (Object)modifier);
                }
                continue;
            }
            attributeModifiers = multimap.get((Object)attribute);
            for (AttributeModifier modifier : attributeModifiers) {
                toReturn.put((Object)attribute, (Object)modifier);
            }
        }
        return toReturn;
    }

    public static Multimap<Attribute, AttributeModifier> increaseByAmount(Multimap<Attribute, AttributeModifier> multimap, Attribute attributeReq, AttributeModifier modifier) {
        HashMultimap toReturn = HashMultimap.create();
        boolean hasBeenAdded = attributeReq == null;
        AttributeModifier.Operation operation = modifier.m_22217_();
        double amount = modifier.m_22218_();
        if ((attributeReq == Attributes.f_22279_ || attributeReq == ForgeMod.SWIM_SPEED.get()) && operation == AttributeModifier.Operation.ADDITION) {
            operation = AttributeModifier.Operation.MULTIPLY_BASE;
            amount *= 0.01;
        }
        for (Attribute attribute : multimap.keys()) {
            Collection attributeModifiers = multimap.get((Object)attribute);
            for (AttributeModifier newModifier : attributeModifiers) {
                if (!hasBeenAdded && attribute == attributeReq && operation == newModifier.m_22217_()) {
                    toReturn.put((Object)attribute, (Object)AttributeHelper.copyWithValue(newModifier, newModifier.m_22218_() + amount));
                    hasBeenAdded = true;
                    continue;
                }
                toReturn.put((Object)attribute, (Object)newModifier);
            }
        }
        if (!hasBeenAdded) {
            toReturn.put((Object)attributeReq, (Object)modifier);
        }
        multimap = toReturn;
        return multimap;
    }

    public static Multimap<Attribute, AttributeModifier> increaseAllByAmount(Multimap<Attribute, AttributeModifier> multimap, Map<Attribute, AttributeModifier> toMerge) {
        for (Attribute attribute : toMerge.keySet()) {
            for (AttributeModifier modifier : List.of(toMerge.get(attribute))) {
                multimap = AttributeHelper.increaseByAmount(multimap, attribute, modifier);
            }
        }
        return multimap;
    }

    public static Multimap<Attribute, AttributeModifier> increaseAllByAmount(Multimap<Attribute, AttributeModifier> map, Multimap<Attribute, AttributeModifier> toMerge) {
        for (Attribute attribute : toMerge.keySet()) {
            for (AttributeModifier modifier : toMerge.get((Object)attribute)) {
                map = AttributeHelper.increaseByAmount(map, attribute, modifier);
            }
        }
        return map;
    }

    public static double getSaveAttributeValue(Attribute attribute, @Nullable LivingEntity living) {
        if (living != null && living.m_21051_(attribute) != null) {
            return living.m_21133_(attribute);
        }
        return 0.0;
    }

    public static double getAttributeValue(@Nullable AttributeInstance instance, double baseValue) {
        if (instance == null) {
            return baseValue;
        }
        double d0 = baseValue + instance.m_22115_();
        for (AttributeModifier attributemodifier : instance.m_22104_(AttributeModifier.Operation.ADDITION)) {
            d0 += attributemodifier.m_22218_();
        }
        double d1 = d0;
        for (AttributeModifier attributeModifier1 : instance.m_22104_(AttributeModifier.Operation.MULTIPLY_BASE)) {
            d1 += d0 * attributeModifier1.m_22218_();
        }
        for (AttributeModifier attributeModifier2 : instance.m_22104_(AttributeModifier.Operation.MULTIPLY_TOTAL)) {
            d1 *= 1.0 + attributeModifier2.m_22218_();
        }
        return instance.m_22099_().m_6740_(d1);
    }

    public static AttributeModifier copyWithValue(AttributeModifier modifier, double value) {
        return new AttributeModifier(modifier.m_22209_(), modifier.m_22214_(), value, modifier.m_22217_());
    }

    public static AttributeModifier addLiquidModifier(@Nullable UUID uuid, String name, AttributeModifier.Operation operation, Function<LivingEntity, Double> transfer, LivingEntity living) {
        if (modUUIDs.containsKey(name) && modUUIDs.get(name) == uuid) {
            return new ChangingAttributeModifier(uuid, name, operation, living, transfer);
        }
        modUUIDs.put(name, Objects.requireNonNullElseGet(uuid, UUID::randomUUID));
        return new ChangingAttributeModifier(modUUIDs.get(name), name, operation, living, transfer);
    }

    public static UUID getByName(String name) {
        return modUUIDs.get(name);
    }

    public static AttributeModifier createModifier(String name, AttributeModifier.Operation operation, double amount) {
        if (!modUUIDs.containsKey(name)) {
            modUUIDs.put(name, UUID.randomUUID());
        }
        return new AttributeModifier(modUUIDs.get(name), name, amount, operation);
    }

    public static AttributeModifier createModifierForSlot(String name, AttributeModifier.Operation operation, double am, EquipmentSlot slot) {
        HashMap<String, UUID> slotUUIDs;
        if (!slotModUUIDs.containsKey(slot)) {
            slotModUUIDs.put(slot, new HashMap());
        }
        if (!(slotUUIDs = slotModUUIDs.get(slot)).containsKey(name)) {
            slotUUIDs.put(name, UUID.randomUUID());
        }
        return new AttributeModifier(slotUUIDs.get(name), name, am, operation);
    }

    public static class AttributeBuilder {
        private Multimap<Attribute, AttributeModifier> modifiers;

        public AttributeBuilder(Multimap<Attribute, AttributeModifier> multimap) {
            this.modifiers = multimap;
        }

        public void merge(Multimap<Attribute, AttributeModifier> toMerge) {
            this.modifiers = AttributeHelper.increaseAllByAmount(this.modifiers, toMerge);
        }

        public void add(Attribute attribute, AttributeModifier modifier) {
            this.modifiers = AttributeHelper.increaseAllByAmount(this.modifiers, Map.of(attribute, modifier));
        }

        public void update(UnaryOperator<Multimap<Attribute, AttributeModifier>> provider) {
            this.modifiers = (Multimap)provider.apply(this.modifiers);
        }

        public void mulAll(double percent) {
            this.modifiers = AttributeHelper.increaseByPercent(this.modifiers, percent, AttributeModifier.Operation.values(), null);
        }

        public void merge(HashMap<Attribute, Double> toMerge, AttributeModifier.Operation operation) {
            for (Attribute attribute : toMerge.keySet()) {
                this.modifiers = AttributeHelper.increaseByAmount(this.modifiers, attribute, new AttributeModifier("AttributeBuilderMerged", toMerge.get(attribute).doubleValue(), operation));
            }
        }

        public Multimap<Attribute, AttributeModifier> build() {
            return this.modifiers;
        }
    }
}

