/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.item.bonus;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.kapitencraft.kap_lib.KapLibMod;
import net.kapitencraft.kap_lib.collection.DoubleMap;
import net.kapitencraft.kap_lib.collection.MapStream;
import net.kapitencraft.kap_lib.helpers.ClientHelper;
import net.kapitencraft.kap_lib.helpers.InventoryHelper;
import net.kapitencraft.kap_lib.io.JsonHelper;
import net.kapitencraft.kap_lib.io.serialization.DataGenSerializer;
import net.kapitencraft.kap_lib.item.bonus.Bonus;
import net.kapitencraft.kap_lib.registry.custom.core.ModRegistries;
import net.kapitencraft.kap_lib.requirements.BonusRequirementType;
import net.kapitencraft.kap_lib.requirements.RequirementManager;
import net.kapitencraft.kap_lib.util.Vec2i;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.tags.TagEntry;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagLoader;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class BonusManager
extends SimpleJsonResourceReloadListener {
    public static BonusManager instance;
    public static final Codec<List<TagEntry>> TAG_ENTRY_LOADER_CODEC;
    private final RegistryAccess access;
    private final Map<ResourceLocation, SetBonusElement> sets = new HashMap<ResourceLocation, SetBonusElement>();
    private final DoubleMap<Item, ResourceLocation, BonusElement> itemBonuses = DoubleMap.create();

    public BonusManager(RegistryAccess access) {
        super(JsonHelper.GSON, "bonuses");
        this.access = access;
    }

    protected void apply(Map<ResourceLocation, JsonElement> pObject, @NotNull ResourceManager pResourceManager, @NotNull ProfilerFiller pProfiler) {
        pObject.forEach((location, element) -> {
            if (location.m_135815_().startsWith("set/")) {
                this.readSetElement(new ResourceLocation(location.m_135827_(), location.m_135815_().substring(4)), (JsonElement)element);
            } else {
                this.readItemElement((ResourceLocation)location, (JsonElement)element);
            }
        });
        pObject.forEach(this::readSetElement);
    }

    private void readItemElement(ResourceLocation location, JsonElement element) {
        try {
            JsonObject main = element.getAsJsonObject();
            ResourceLocation itemLocation = new ResourceLocation(GsonHelper.m_13906_((JsonObject)main, (String)"item"));
            Item item = (Item)ForgeRegistries.ITEMS.getValue(itemLocation);
            if (item == null) {
                throw new IllegalArgumentException("unknown Item: " + itemLocation);
            }
            DataGenSerializer<Bonus<?>> serializer = BonusManager.readFromString(GsonHelper.m_13906_((JsonObject)main, (String)"type"));
            Bonus bonus = (Bonus)serializer.deserialize((Bonus<?>)GsonHelper.m_13930_((JsonObject)main, (String)"data"));
            boolean hidden = GsonHelper.m_13912_((JsonObject)main, (String)"hidden");
            this.addItemIfAbsent(item);
            this.itemBonuses.putIfAbsent(item, location, new BonusElement(hidden, bonus));
        }
        catch (Exception e) {
            KapLibMod.LOGGER.warn("error loading item bonus: {}", (Object)e.getMessage());
        }
    }

    private void addItemIfAbsent(Item item) {
        if (!this.itemBonuses.containsKey(item)) {
            this.itemBonuses.put(item, new HashMap());
        }
    }

    private void addElementForItem(Item item, ResourceLocation location, BonusElement element) {
        this.addItemIfAbsent(item);
    }

    public static List<Component> getBonusDisplay(ItemStack stack, LivingEntity living) {
        Map<ResourceLocation, BonusElement> available = instance.getBonusesForItem(stack, living, true);
        ArrayList<Component> components = new ArrayList<Component>();
        available.forEach((location, bonus) -> components.addAll(instance.decorateBonus(living, (ResourceLocation)location, (BonusElement)bonus)));
        return components;
    }

    private static DataGenSerializer<? extends Bonus<?>> readFromString(String string) {
        return (DataGenSerializer)ModRegistries.BONUS_SERIALIZER.getValue(new ResourceLocation(string));
    }

    private void readSetElement(ResourceLocation location, JsonElement jsonElement) {
        try {
            JsonObject main = jsonElement.getAsJsonObject();
            HashMap<EquipmentSlot, TagKey<Item>> itemsForSlot = new HashMap<EquipmentSlot, TagKey<Item>>();
            JsonObject items = GsonHelper.m_13930_((JsonObject)main, (String)"items");
            HashMap<ResourceLocation, List<TagLoader.EntryWithSource>> tagEntriesForBonus = new HashMap<ResourceLocation, List<TagLoader.EntryWithSource>>();
            for (EquipmentSlot slot : EquipmentSlot.values()) {
                if (!items.has(slot.m_20751_())) continue;
                ResourceLocation locationForSlot = new ResourceLocation(location.m_135827_(), "set/" + location.m_135815_() + "/" + slot.m_20751_());
                JsonObject itemElements = GsonHelper.m_13930_((JsonObject)items, (String)slot.m_20751_());
                List tagEntries = (List)TAG_ENTRY_LOADER_CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)itemElements).getOrThrow(false, arg_0 -> ((Logger)KapLibMod.LOGGER).error(arg_0));
                tagEntriesForBonus.put(locationForSlot, tagEntries.stream().map(tagEntry -> new TagLoader.EntryWithSource(tagEntry, locationForSlot.toString())).toList());
                itemsForSlot.put(slot, (TagKey<Item>)TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)locationForSlot));
            }
            if (tagEntriesForBonus.size() < 2) {
                throw new IllegalStateException("set bonuses require at least two used slots to work");
            }
            TagLoader loader = new TagLoader(arg_0 -> ((IForgeRegistry)ForgeRegistries.ITEMS).getHolder(arg_0), "set_bonuses");
            Registry registry = this.access.m_175515_(Registries.f_256913_);
            loader.m_203898_(tagEntriesForBonus).forEach((tagLocation, holders) -> {
                TagKey tagKey = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)tagLocation);
                registry.m_203561_(tagKey).m_205835_(List.copyOf(holders));
            });
            DataGenSerializer<Bonus<?>> serializer = BonusManager.readFromString(GsonHelper.m_13906_((JsonObject)main, (String)"type"));
            Bonus bonus = (Bonus)serializer.deserialize((Bonus<?>)GsonHelper.m_13930_((JsonObject)main, (String)"bonus"));
            boolean hidden = GsonHelper.m_13912_((JsonObject)main, (String)"hidden");
            this.sets.put(location, new SetBonusElement(hidden, bonus, itemsForSlot));
        }
        catch (Exception e) {
            KapLibMod.LOGGER.warn("error loading bonus: {}", (Object)e.getMessage());
        }
    }

    private Map<ResourceLocation, BonusElement> getBonusesForItem(ItemStack stack, LivingEntity living, boolean ignoreHidden) {
        Map itemBonuses = MapStream.of((Map)this.itemBonuses.get(stack.m_41720_())).filterValues(bonusElement -> !bonusElement.hidden || ignoreHidden, null).toMap();
        Map<ResourceLocation, SetBonusElement> setBonuses = MapStream.of(this.sets).filter((location, setBonusElement) -> setBonusElement.itemsForSlot.values().stream().anyMatch(arg_0 -> ((ItemStack)stack).m_204117_(arg_0))).toMap();
        HashMap<ResourceLocation, BonusElement> allBonuses = new HashMap<ResourceLocation, BonusElement>();
        allBonuses.putAll(itemBonuses);
        allBonuses.putAll(setBonuses);
        return allBonuses;
    }

    private Map<ResourceLocation, BonusElement> getAllBonuses(LivingEntity living) {
        HashMap<ResourceLocation, BonusElement> bonuses = new HashMap<ResourceLocation, BonusElement>();
        InventoryHelper.equipment(living).values().stream().map(ItemStack::m_41720_).map(this.itemBonuses::get).forEach(bonuses::putAll);
        bonuses.putAll(this.getActiveSetBonuses(living, false));
        return bonuses;
    }

    private List<Component> decorateBonus(LivingEntity living, ResourceLocation bonusLocation, BonusElement element) {
        ArrayList<Component> decoration = new ArrayList<Component>();
        boolean enabled = RequirementManager.instance.meetsRequirements(BonusRequirementType.INSTANCE, element, living);
        decoration.add(this.getBonusTitle(enabled, living, bonusLocation, element));
        Bonus<?> bonus = element.bonus;
        bonus.getDisplay().accept(decoration);
        ClientHelper.addReqContent(decoration::add, BonusRequirementType.INSTANCE, element, living);
        return decoration;
    }

    private Component getBonusTitle(boolean enabled, LivingEntity living, ResourceLocation location, BonusElement element) {
        boolean bl;
        if (element instanceof SetBonusElement) {
            SetBonusElement setBonusElement = (SetBonusElement)element;
            bl = true;
        } else {
            bl = false;
        }
        boolean set = bl;
        MutableComponent name = Component.m_237115_((String)((set ? "set." : "") + "bonus." + location.m_135827_() + "." + location.m_135815_())).m_130944_(new ChatFormatting[]{enabled ? ChatFormatting.GOLD : ChatFormatting.DARK_GRAY, ChatFormatting.BOLD});
        MutableComponent start = Component.m_237115_((String)((set ? "set." : "") + "bonus.name"));
        MutableComponent join1 = start.m_130946_(": ").m_7220_((Component)name);
        if (element instanceof SetBonusElement) {
            SetBonusElement setBonusElement = (SetBonusElement)element;
            Vec2i count = this.getSetBonusCount(living, setBonusElement);
            join1.m_130946_(" (").m_7220_((Component)Component.m_237113_((String)String.valueOf(count.x)).m_130940_(ChatFormatting.AQUA)).m_130946_("/").m_7220_((Component)Component.m_237113_((String)String.valueOf(count.y)).m_130940_(ChatFormatting.DARK_AQUA)).m_130946_(")");
        }
        return join1;
    }

    private Vec2i getSetBonusCount(LivingEntity living, SetBonusElement element) {
        List<Boolean> booleans = MapStream.of(InventoryHelper.equipment(living)).mapToSimple((slot, stack) -> element.itemsForSlot.containsKey(slot) ? Boolean.valueOf(stack.m_204117_(element.itemsForSlot.get(slot))) : null).toList();
        int c = 0;
        for (Boolean aBoolean : booleans) {
            if (!aBoolean.booleanValue()) continue;
            ++c;
        }
        return new Vec2i(c, booleans.size());
    }

    private Map<ResourceLocation, SetBonusElement> getActiveSetBonuses(LivingEntity living, boolean ignoreHidden) {
        Map<EquipmentSlot, ItemStack> equipment = InventoryHelper.equipment(living);
        HashMap<ResourceLocation, SetBonusElement> bonuses = new HashMap<ResourceLocation, SetBonusElement>();
        this.sets.forEach((location, setBonusElement) -> {
            if (Arrays.stream(EquipmentSlot.values()).allMatch(slot -> !setBonusElement.requiresSlot((EquipmentSlot)slot) || setBonusElement.matchesItem((EquipmentSlot)slot, (ItemStack)equipment.get(slot))) && !setBonusElement.isHidden() || ignoreHidden) {
                bonuses.put((ResourceLocation)location, (SetBonusElement)setBonusElement);
            }
        });
        return bonuses;
    }

    static {
        TAG_ENTRY_LOADER_CODEC = TagEntry.f_215911_.listOf();
    }

    public static class BonusElement {
        private final boolean hidden;
        private final Bonus<?> bonus;

        private BonusElement(boolean hidden, Bonus<?> bonus) {
            this.hidden = hidden;
            this.bonus = bonus;
        }

        public boolean isHidden() {
            return this.hidden;
        }

        public Bonus<?> getBonus() {
            return this.bonus;
        }
    }

    private static class SetBonusElement
    extends BonusElement {
        private final Map<EquipmentSlot, TagKey<Item>> itemsForSlot;

        private SetBonusElement(boolean hidden, Bonus<?> bonus, Map<EquipmentSlot, TagKey<Item>> itemsForSlot) {
            super(hidden, bonus);
            this.itemsForSlot = itemsForSlot;
        }

        public boolean requiresSlot(EquipmentSlot slot) {
            return this.itemsForSlot.containsKey(slot);
        }

        public boolean matchesItem(EquipmentSlot slot, ItemStack stack) {
            return stack.m_204117_(this.itemsForSlot.get(slot));
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object obj) {
            if (obj instanceof EquipmentSlot) {
                EquipmentSlot slot = (EquipmentSlot)obj;
                if (this.requiresSlot(slot)) return true;
            }
            if (obj instanceof ItemStack) {
                ItemStack stack = (ItemStack)obj;
                if (this.itemsForSlot.values().stream().anyMatch(arg_0 -> ((ItemStack)stack).m_204117_(arg_0))) return true;
            }
            if (!(obj instanceof SetBonusElement)) return false;
            SetBonusElement element = (SetBonusElement)obj;
            if (element.isHidden() != this.isHidden()) return false;
            if (!element.getBonus().equals(this.getBonus())) return false;
            if (!element.itemsForSlot.equals(this.itemsForSlot)) return false;
            return true;
        }
    }
}

