/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.item.bonus.type;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.kapitencraft.kap_lib.io.serialization.DataGenSerializer;
import net.kapitencraft.kap_lib.item.bonus.Bonus;
import net.kapitencraft.kap_lib.registry.custom.ModSetBonusTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class SimpleSetMobEffect
implements Bonus<SimpleSetMobEffect> {
    private static final Codec<MobEffectInstance> EFFECT_INSTANCE_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ForgeRegistries.MOB_EFFECTS.getCodec().fieldOf("effect").forGetter(MobEffectInstance::m_19544_), (App)Codec.INT.fieldOf("duration").forGetter(MobEffectInstance::m_19557_), (App)Codec.INT.fieldOf("amplifier").forGetter(MobEffectInstance::m_19564_)).apply((Applicative)instance, MobEffectInstance::new));
    public static final Codec<SimpleSetMobEffect> CODEC = EFFECT_INSTANCE_CODEC.listOf().xmap(SimpleSetMobEffect::new, SimpleSetMobEffect::getEffects);
    private final List<MobEffectInstance> effects = new ArrayList<MobEffectInstance>();

    public SimpleSetMobEffect(List<MobEffectInstance> effects) {
        this.effects.addAll(effects);
    }

    private List<MobEffectInstance> getEffects() {
        return this.effects;
    }

    @Override
    public DataGenSerializer<SimpleSetMobEffect> getSerializer() {
        return (DataGenSerializer)ModSetBonusTypes.SIMPLE_MOB_EFFECT.get();
    }

    @Override
    public void additionalToNetwork(FriendlyByteBuf buf) {
        buf.m_236828_(this.effects, SimpleSetMobEffect::writeEffect);
    }

    @Override
    public void onTick(Level level, @NotNull LivingEntity entity) {
        this.effects.stream().map(MobEffectInstance::new).forEach(arg_0 -> ((LivingEntity)entity).m_7292_(arg_0));
    }

    @Override
    public Consumer<List<Component>> getDisplay() {
        return null;
    }

    private static void writeEffect(FriendlyByteBuf buf, MobEffectInstance instance) {
        buf.writeRegistryId(ForgeRegistries.MOB_EFFECTS, (Object)instance.m_19544_());
        buf.writeInt(instance.m_19557_());
        buf.writeInt(instance.m_19564_());
    }

    public static SimpleSetMobEffect fromNetwork(FriendlyByteBuf buf) {
        return new SimpleSetMobEffect((List)buf.m_236838_(ArrayList::new, SimpleSetMobEffect::readEffect));
    }

    private static MobEffectInstance readEffect(FriendlyByteBuf buf) {
        MobEffect effect = (MobEffect)buf.readRegistryId();
        int duration = buf.readInt();
        int amplifier = buf.readInt();
        return new MobEffectInstance(effect, duration, amplifier);
    }
}

