/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.requirements.type;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.kapitencraft.kap_lib.helpers.TextHelper;
import net.kapitencraft.kap_lib.io.serialization.DataGenSerializer;
import net.kapitencraft.kap_lib.registry.custom.ModRequirementTypes;
import net.kapitencraft.kap_lib.requirements.type.abstracts.ReqCondition;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class DimensionReqCondition
extends ReqCondition<DimensionReqCondition> {
    public static final Codec<DimensionReqCondition> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceKey.m_195966_((ResourceKey)Registries.f_256858_).listOf().fieldOf("dimensions").forGetter(i -> i.dimensions), (App)Codec.BOOL.fieldOf("inverted").forGetter(i -> i.inverted)).apply((Applicative)instance, DimensionReqCondition::new));
    private final List<ResourceKey<Level>> dimensions;
    private final boolean inverted;

    public DimensionReqCondition(List<ResourceKey<Level>> dimensionKey, boolean inverted) {
        this.dimensions = dimensionKey;
        this.inverted = inverted;
    }

    @Override
    @NotNull
    public Component cacheDisplay() {
        Object key = "dimension_req.display";
        if (this.inverted) {
            key = (String)key + ".inverted";
        }
        List<MutableComponent> dimensionsBaked = this.dimensions.stream().map(ResourceKey::m_135782_).map(ResourceLocation::toString).map(s -> s.replace(':', '.')).map(s -> Component.m_237115_((String)("dimension." + s))).toList();
        return Component.m_237110_((String)key, (Object[])new Object[]{TextHelper.chain(dimensionsBaked, true)});
    }

    @Override
    public void additionalToNetwork(FriendlyByteBuf buf) {
        buf.m_236828_(this.dimensions, FriendlyByteBuf::m_236858_);
        buf.writeBoolean(this.inverted);
    }

    public static DimensionReqCondition fromNetwork(FriendlyByteBuf buf) {
        return new DimensionReqCondition(buf.m_236845_(buf1 -> buf1.m_236801_(Registries.f_256858_)), buf.readBoolean());
    }

    @Override
    public boolean matches(LivingEntity entity) {
        return this.inverted != this.dimensions.contains(entity.m_9236_().m_46472_());
    }

    @Override
    public DataGenSerializer<DimensionReqCondition> getSerializer() {
        return (DataGenSerializer)ModRequirementTypes.DIMENSION.get();
    }
}

