/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.requirements.type.abstracts;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.Codec;
import java.util.Objects;
import net.kapitencraft.kap_lib.io.serialization.DataGenSerializer;
import net.kapitencraft.kap_lib.io.serialization.IDataGenElement;
import net.kapitencraft.kap_lib.registry.custom.core.ModRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.NotNull;

public abstract class ReqCondition<T extends ReqCondition<T>>
implements IDataGenElement<T> {
    private Component displayCache;

    public static <T extends ReqCondition<T>> DataGenSerializer<T> createSerializer(Codec<T> codec, FriendlyByteBuf.Reader<T> reader) {
        return IDataGenElement.createSerializer(codec, reader);
    }

    public static <T extends ReqCondition<T>> ReqCondition<T> fromNetwork(FriendlyByteBuf buf) {
        return (ReqCondition)IDataGenElement.fromNetwork(buf);
    }

    public static <T extends ReqCondition<T>> ReqCondition<T> readFromJson(JsonObject object) {
        DataGenSerializer serializer = (DataGenSerializer)ModRegistries.REQUIREMENT_TYPE.getValue(new ResourceLocation(GsonHelper.m_13906_((JsonObject)object, (String)"type")));
        if (serializer == null) {
            throw new NullPointerException("unknown requirement type: '" + GsonHelper.m_13906_((JsonObject)object, (String)"type") + "'");
        }
        return (ReqCondition)serializer.deserialize(GsonHelper.m_13930_((JsonObject)object, (String)"data"));
    }

    protected ReqCondition() {
    }

    @Override
    public final void toNetwork(FriendlyByteBuf byteBuf) {
        byteBuf.writeRegistryId(ModRegistries.REQUIREMENT_TYPE, this.getSerializer());
        this.additionalToNetwork(byteBuf);
    }

    @Override
    public final JsonObject toJson() {
        JsonObject object = new JsonObject();
        object.add("data", (JsonElement)this.getSerializer().serialize(this));
        object.addProperty("type", Objects.requireNonNull(ModRegistries.REQUIREMENT_TYPE.getKey(this.getSerializer()), String.format("unknown requirement type: %s", this.getClass().getCanonicalName())).toString());
        return object;
    }

    public abstract boolean matches(LivingEntity var1);

    @Override
    public abstract DataGenSerializer<T> getSerializer();

    @NotNull
    protected abstract Component cacheDisplay();

    @NotNull
    public Component display() {
        return this.displayCache == null ? (this.displayCache = this.cacheDisplay()) : this.displayCache;
    }
}

