/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.util;

import java.util.List;
import net.kapitencraft.kap_lib.config.ClientModConfig;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.joml.Vector2i;

@Mod.EventBusSubscriber(value={Dist.CLIENT})
public class ScrollableTooltips {
    private static int scrollY = 0;
    private static int initY = 0;
    private static float scale = 1.0f;
    private static int oldTooltipSize = 0;
    private static ItemStack stack = ItemStack.f_41583_;

    @SubscribeEvent
    public static void registerScrollable(RenderTooltipEvent.Pre event) {
        int i;
        boolean isHigherThanScreen;
        Vector2i toolTipSize = ScrollableTooltips.createToolTipBoxSize(event.getComponents(), event.getFont());
        Vector2i screenSize = new Vector2i(event.getScreenWidth(), event.getScreenHeight());
        Vector2i pos = new Vector2i(event.getX(), event.getY());
        int height = event.getY();
        boolean bl = isHigherThanScreen = toolTipSize.y > screenSize.y || height + toolTipSize.y > screenSize.y;
        if (stack != event.getItemStack()) {
            scrollY = 0;
            stack = event.getItemStack();
        }
        if (!(scrollY != 0 && isHigherThanScreen || pos.y + (i = toolTipSize.y + 3) <= screenSize.y)) {
            height = screenSize.y - i;
        }
        if (isHigherThanScreen) {
            if (oldTooltipSize != toolTipSize.y && oldTooltipSize != 0) {
                scrollY *= (int)((double)toolTipSize.y / (double)oldTooltipSize);
                oldTooltipSize = toolTipSize.y;
            }
            if (scrollY == 0) {
                initY = height;
            }
            event.setY(initY + scrollY);
            return;
        }
        event.setY(height);
    }

    @SubscribeEvent
    public static void scrollEvent(ScreenEvent.MouseScrolled.Pre event) {
        double scrollScale = ClientModConfig.getScrollScale();
        if (stack != ItemStack.f_41583_) {
            float scrollDelta = (float)event.getScrollDelta();
            int scrollOffset = Mth.m_14107_((double)((double)scrollDelta * scrollScale));
            if (Screen.m_96637_()) {
                scale += (float)scrollOffset;
            } else {
                scrollY -= scrollOffset;
            }
        }
    }

    private static Vector2i createToolTipBoxSize(List<ClientTooltipComponent> components, Font font) {
        int i = 0;
        int j = 0;
        for (ClientTooltipComponent clienttooltipcomponent : components) {
            int k = clienttooltipcomponent.m_142069_(font);
            if (k > i) {
                i = k;
            }
            j += clienttooltipcomponent.m_142103_();
        }
        return new Vector2i(i, j);
    }
}

