/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.client.armor;

import net.kapitencraft.kap_lib.client.armor.ArmorModel;
import net.kapitencraft.kap_lib.client.armor.provider.ArmorModelProvider;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.Model;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.NotNull;

public class ArmorClientExtension
implements IClientItemExtensions {
    private final ArmorModelProvider provider;

    public ArmorClientExtension(ArmorModelProvider provider) {
        this.provider = provider;
    }

    @NotNull
    public ArmorModel getHumanoidArmorModel(LivingEntity living, ItemStack stack, EquipmentSlot slot, HumanoidModel<?> original) {
        ArmorModel armorModel = this.provider.getModel(living, stack, slot);
        armorModel.partVisible(slot);
        armorModel.crouching = original.crouching;
        armorModel.riding = original.riding;
        armorModel.young = original.young;
        return armorModel;
    }

    @NotNull
    public Model getGenericArmorModel(LivingEntity livingEntity, ItemStack itemStack, EquipmentSlot equipmentSlot, HumanoidModel<?> original) {
        HumanoidModel model = this.getHumanoidArmorModel(livingEntity, itemStack, equipmentSlot, (HumanoidModel)original);
        this.copyModelProperties(original, (ArmorModel)model);
        return model;
    }

    private <T extends LivingEntity> void copyModelProperties(HumanoidModel<T> original, ArmorModel replacement) {
        original.copyPropertiesTo((HumanoidModel)replacement);
        replacement.rightBoot.copyFrom(original.rightLeg);
        replacement.leftBoot.copyFrom(original.leftLeg);
    }
}

