/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.spawn_table;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.kapitencraft.kap_lib.spawn_table.entries.DynamicSpawn;
import net.minecraft.core.HolderGetter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootParams;

public class SpawnContext
extends LootContext {
    private final Map<ResourceLocation, DynamicSpawn> dynamicSpawns = new HashMap<ResourceLocation, DynamicSpawn>();

    SpawnContext(LootParams params, RandomSource randomsource, HolderGetter.Provider provider) {
        super(params, randomsource, provider);
    }

    public void addDynamicSpawn(ResourceLocation pName, Consumer<Entity> pConsumer) {
        DynamicSpawn spawn = this.dynamicSpawns.get(pName);
        if (spawn != null) {
            spawn.createEntity(pConsumer, this);
        }
    }

    public static class Builder {
        private final LootParams params;
        @Nullable
        private RandomSource random;
        private ResourceLocation queriedLootTableId;

        public Builder(LootParams pParams) {
            this.params = pParams;
        }

        public Builder(SpawnContext context) {
            this.params = context.params;
            this.random = context.random;
        }

        public Builder withOptionalRandomSeed(long pSeed) {
            if (pSeed != 0L) {
                this.random = RandomSource.create((long)pSeed);
            }
            return this;
        }

        public Builder withQueriedLootTableId(ResourceLocation queriedLootTableId) {
            this.queriedLootTableId = queriedLootTableId;
            return this;
        }

        public ServerLevel getLevel() {
            return this.params.getLevel();
        }

        public SpawnContext create(@Nullable ResourceLocation pRandomLocation) {
            ServerLevel serverlevel = this.getLevel();
            MinecraftServer minecraftserver = serverlevel.getServer();
            RandomSource randomsource = this.random != null ? this.random : (pRandomLocation != null ? serverlevel.getRandomSequence(pRandomLocation) : serverlevel.getRandom());
            return new SpawnContext(this.params, randomsource, minecraftserver.reloadableRegistries().lookup());
        }
    }
}

