/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.model.geom.ModelLayers;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BannerRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.core.Holder;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.item.BannerItem;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BannerBlockEntity;
import net.minecraft.world.level.block.entity.BannerPattern;

public class BannerPatternRenderer {
    private static final Minecraft MINECRAFT = Minecraft.m_91087_();
    private static final ModelPart FLAG = MINECRAFT.m_167973_().m_171103_(ModelLayers.f_171264_).m_171324_("flag");

    public static ModelPart getFlag() {
        return FLAG;
    }

    public static void renderBanner(GuiGraphics graphics, float x, float y, List<Pair<Holder<BannerPattern>, DyeColor>> patterns, int height) {
        MultiBufferSource.BufferSource source = MINECRAFT.m_91269_().m_110104_();
        PoseStack poseStack = graphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_(x, y + (float)height, 0.0f);
        float scale = (float)height / 40.0f;
        poseStack.m_85841_(24.0f * scale, -24.0f * scale, 1.0f);
        poseStack.m_252880_(0.5f, 0.5f, 0.0f);
        float f = 0.6666667f;
        poseStack.m_85841_(f, -f, -f);
        BannerRenderer.m_112065_((PoseStack)poseStack, (MultiBufferSource)source, (int)0xF000F0, (int)OverlayTexture.f_118083_, (ModelPart)FLAG, (Material)ModelBakery.f_119224_, (boolean)true, patterns);
        poseStack.m_85849_();
        source.m_109911_();
    }

    public static void renderBannerFromStack(GuiGraphics graphics, int x, int y, ItemStack stack, int height) {
        BannerPatternRenderer.renderBanner(graphics, x, y, BannerPatternRenderer.fromStack(stack), height);
    }

    public static List<Pair<Holder<BannerPattern>, DyeColor>> fromStack(ItemStack bannerStack) {
        BannerItem banner = (BannerItem)bannerStack.m_41720_();
        return BannerBlockEntity.m_58484_((DyeColor)banner.m_40545_(), (ListTag)BannerBlockEntity.m_58487_((ItemStack)bannerStack));
    }

    static {
        BannerPatternRenderer.FLAG.f_104203_ = 0.0f;
        BannerPatternRenderer.FLAG.f_104201_ = -32.0f;
    }
}

