/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.client.overlay;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import net.kapitencraft.kap_lib.KapLibMod;
import net.kapitencraft.kap_lib.client.LibClient;
import net.kapitencraft.kap_lib.client.overlay.OverlayLocation;
import net.kapitencraft.kap_lib.client.overlay.OverlayProperties;
import net.kapitencraft.kap_lib.client.overlay.box.InteractiveBox;
import net.kapitencraft.kap_lib.client.overlay.holder.Overlay;
import net.kapitencraft.kap_lib.collection.MapStream;
import net.kapitencraft.kap_lib.event.custom.ModEventFactory;
import net.kapitencraft.kap_lib.event.custom.client.RegisterOverlaysEvent;
import net.kapitencraft.kap_lib.helpers.ClientHelper;
import net.kapitencraft.kap_lib.helpers.CollectionHelper;
import net.kapitencraft.kap_lib.helpers.IOHelper;
import net.kapitencraft.kap_lib.helpers.MiscHelper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.phys.Vec2;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterGuiOverlaysEvent;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import org.jetbrains.annotations.NotNull;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
public class OverlayController {
    private static final Codec<OverlayController> CODEC = RecordCodecBuilder.create(renderControllerInstance -> renderControllerInstance.group((App)Codec.unboundedMap(IOHelper.UUID_CODEC, OverlayProperties.CODEC).fieldOf("storage").forGetter(OverlayController::getLocations)).apply((Applicative)renderControllerInstance, OverlayController::fromCodec));
    private static File PERSISTENT_FILE;
    private final Map<OverlayLocation, Function<OverlayProperties, Overlay>> constructors = new HashMap<OverlayLocation, Function<OverlayProperties, Overlay>>();
    public final Map<OverlayLocation, Overlay> map = new HashMap<OverlayLocation, Overlay>();
    private final Map<UUID, OverlayProperties> loadedPositions = new HashMap<UUID, OverlayProperties>();

    private static OverlayController fromCodec(Map<UUID, OverlayProperties> map) {
        OverlayController controller = new OverlayController();
        controller.loadedPositions.putAll(map);
        return controller;
    }

    private Map<UUID, OverlayProperties> getLocations() {
        return MapStream.of(this.map).mapValues(Overlay::getProperties).mapKeys(OverlayLocation::getUUID).toMap();
    }

    @NotNull
    private static File getOrCreateFile() {
        if (PERSISTENT_FILE == null) {
            PERSISTENT_FILE = new File(KapLibMod.MAIN, "gui-locations.json");
        }
        return PERSISTENT_FILE;
    }

    public static OverlayController load() {
        return IOHelper.loadFile(OverlayController.getOrCreateFile(), CODEC, OverlayController::new);
    }

    private OverlayController() {
        this.register();
    }

    private void register() {
        ModEventFactory.fireModEvent(new RegisterOverlaysEvent(this::createRenderer));
        this.construct();
    }

    private void createRenderer(OverlayLocation provider, Function<OverlayProperties, Overlay> constructor) {
        if (this.constructors.containsKey(provider)) {
            throw new IllegalStateException("detected double registered Overlay with UUID '" + provider.getUUID() + "'");
        }
        this.constructors.put(provider, constructor);
    }

    public static void save() {
        IOHelper.saveFile(OverlayController.getOrCreateFile(), CODEC, LibClient.controller);
    }

    @SubscribeEvent
    public static void overlays(RegisterGuiOverlaysEvent event) {
        event.registerAboveAll("main", LibClient.controller::render);
    }

    public void fillRenderBoxes(Consumer<InteractiveBox> acceptor, LocalPlayer player, Font font, float width, float height) {
        this.map.values().stream().map(renderHolder -> renderHolder.newBox(width, height, player, font)).forEach(acceptor);
    }

    private void render(ForgeGui forgeGui, GuiGraphics graphics, float partialTicks, int screenWidth, int screenHeight) {
        LocalPlayer entity = Minecraft.m_91087_().f_91074_;
        if (entity != null && !ClientHelper.hideGui()) {
            this.map.forEach((uuid, renderHolder) -> {
                graphics.m_280168_().m_85836_();
                OverlayProperties holder = renderHolder.getProperties();
                Vec2 renderLocation = renderHolder.getLoc(screenWidth, screenHeight);
                graphics.m_280168_().m_252880_(renderLocation.f_82470_, renderLocation.f_82471_, 0.0f);
                graphics.m_280168_().m_85841_(holder.getXScale(), holder.getYScale(), 0.0f);
                renderHolder.render(graphics, screenWidth, screenHeight, entity);
                graphics.m_280168_().m_85849_();
            });
        }
    }

    private void construct() {
        this.constructors.forEach((location, constructor) -> {
            OverlayProperties holder = MiscHelper.nonNullOr(this.loadedPositions.get(location.getUUID()), location.getDefault().createCopy());
            this.map.put((OverlayLocation)location, (Overlay)constructor.apply(holder));
        });
    }

    public void reset(Overlay dedicatedHolder) {
        if (this.map.containsValue(dedicatedHolder)) {
            OverlayLocation location = CollectionHelper.getKeyForValue(this.map, dedicatedHolder);
            dedicatedHolder.getProperties().copy(location.getDefault());
            return;
        }
        throw new IllegalStateException("attempted to reset non-existing Holder");
    }

    public static void resetAll() {
        OverlayController controller = LibClient.controller;
        Set<OverlayLocation> locations = controller.constructors.keySet();
        locations.forEach(location -> {
            Overlay holder = controller.map.get(location);
            holder.getProperties().copy(location.getDefault());
        });
    }
}

