/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.client.overlay.box;

import net.kapitencraft.kap_lib.client.overlay.box.InteractiveBox;
import net.kapitencraft.kap_lib.client.overlay.box.ResizeBox;
import net.kapitencraft.kap_lib.client.overlay.holder.Overlay;
import net.minecraft.world.phys.Vec2;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
class ResizeAccessBox
extends InteractiveBox {
    private final ResizeBox.Type type;
    private final ResizeBox parent;
    private static final float lineWidth = 0.5f;
    private static final float squareSize = 1.5f;

    protected ResizeAccessBox(Vec2 start, Vec2 finish, int cursorType, int color, Overlay dedicatedHolder, ResizeBox.Type type, ResizeBox parent) {
        super(start, finish, cursorType, color, dedicatedHolder);
        this.type = type;
        this.parent = parent;
    }

    protected ResizeAccessBox(int color, Overlay dedicated, ResizeBox.Type type, ResizeBox box) {
        this(Vec2.f_82462_, Vec2.f_82462_, -1, color, dedicated, type, box);
    }

    protected ResizeBox.Type getType() {
        return this.type;
    }

    protected int getCursorType() {
        return switch (this.type) {
            default -> throw new IncompatibleClassChangeError();
            case ResizeBox.Type.E, ResizeBox.Type.W -> 221189;
            case ResizeBox.Type.N, ResizeBox.Type.S -> 221190;
            case ResizeBox.Type.NW, ResizeBox.Type.SE -> 221191;
            case ResizeBox.Type.NE, ResizeBox.Type.SW -> 221192;
            case ResizeBox.Type.C -> 221193;
        };
    }

    @Override
    public int getCursorType(double mouseX, double mouseY) {
        return this.getCursorType();
    }

    protected void reapplyPosition() {
        Vec2 start = this.parent.start;
        Vec2 finish = this.parent.finish;
        Vec2 bottomLeft = new Vec2(start.f_82470_, finish.f_82471_);
        Vec2 topRight = new Vec2(finish.f_82470_, start.f_82471_);
        switch (this.type) {
            case E: {
                this.applyLine(topRight, finish, 0.5f);
                break;
            }
            case SE: {
                this.applySquare(finish, 1.5f);
                break;
            }
            case S: {
                this.applyLine(bottomLeft, finish, 0.5f);
                break;
            }
            case SW: {
                this.applySquare(bottomLeft, 1.5f);
                break;
            }
            case W: {
                this.applyLine(start, bottomLeft, 0.5f);
                break;
            }
            case NW: {
                this.applySquare(start, 1.5f);
                break;
            }
            case N: {
                this.applyLine(start, topRight, 0.5f);
                break;
            }
            case NE: {
                this.applySquare(topRight, 1.5f);
            }
        }
    }

    public void applyLine(Vec2 start, Vec2 finish, float lineW) {
        boolean horizontal = start.f_82470_ == finish.f_82470_;
        this.start = new Vec2(horizontal ? start.f_82470_ - lineW : start.f_82470_, horizontal ? start.f_82471_ : start.f_82471_ - lineW);
        this.finish = new Vec2(horizontal ? finish.f_82470_ + lineW : finish.f_82470_, horizontal ? finish.f_82471_ : finish.f_82471_ + lineW);
    }

    public void applySquare(Vec2 center, float size) {
        this.start = center.m_165910_(new Vec2(-size, -size));
        this.finish = center.m_165910_(new Vec2(size, size));
    }
}

