/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.helpers;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import net.kapitencraft.kap_lib.collection.MapStream;
import net.kapitencraft.kap_lib.enchantments.abstracts.ExtendedAbilityEnchantment;
import net.kapitencraft.kap_lib.event.custom.ModEventFactory;
import net.kapitencraft.kap_lib.item.IEventListener;
import net.kapitencraft.kap_lib.item.bonus.IArmorBonusItem;
import net.kapitencraft.kap_lib.item.bonus.IItemBonusItem;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public interface BonusHelper {
    public static void tickEnchantments(LivingEntity living) {
        BonusHelper.doForSlot((stack, slot) -> MapStream.of(stack.getAllEnchantments()).filterKeys(e -> e instanceof ExtendedAbilityEnchantment).mapKeys(ExtendedAbilityEnchantment.class::cast).forEach((enchantment, integer) -> enchantment.onTick(living, (int)integer)), living, (stack, slot) -> stack.m_41793_());
    }

    public static List<IEventListener> getListenersFromStack(EquipmentSlot slot, ItemStack stack, LivingEntity living) {
        ArrayList<IEventListener> bonuses = new ArrayList<IEventListener>();
        Item item = stack.m_41720_();
        if (item instanceof IItemBonusItem) {
            IItemBonusItem bonusItem = (IItemBonusItem)item;
            bonuses.add(bonusItem.getBonus());
            bonuses.add(bonusItem.getExtraBonus());
            Item item2 = stack.m_41720_();
            if (item2 instanceof ArmorItem) {
                ArmorItem armorItem = (ArmorItem)item2;
                bonuses.addAll(BonusHelper.getArmorBonuses(armorItem, living, slot));
            }
        }
        ModEventFactory.fetchItemBonuses(bonuses, stack, slot);
        return bonuses.stream().filter(Objects::nonNull).toList();
    }

    private static List<IEventListener> getArmorBonuses(ArmorItem armorItem, LivingEntity living, EquipmentSlot slot) {
        ArrayList<IEventListener> list = new ArrayList<IEventListener>();
        if (armorItem instanceof IArmorBonusItem) {
            IArmorBonusItem armorBonusItem = (IArmorBonusItem)armorItem;
            if (armorItem.m_40402_() == slot) {
                armorBonusItem.getPieceBonni().stream().filter(multiPieceBonus -> multiPieceBonus.isActive(living, slot)).forEach(list::add);
                list.add(armorBonusItem.getExtraBonus(slot));
                list.add(armorBonusItem.getPieceBonusForSlot(slot));
            }
        }
        return list;
    }

    public static void doForSlot(BiConsumer<ItemStack, EquipmentSlot> stackConsumer, LivingEntity living, BiPredicate<ItemStack, EquipmentSlot> usagePredicate) {
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            ItemStack stack = living.m_6844_(slot);
            if (!usagePredicate.test(stack, slot)) continue;
            stackConsumer.accept(stack, slot);
        }
    }
}

