/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.item.combat.armor;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.function.Consumer;
import net.kapitencraft.kap_lib.item.combat.armor.client.renderer.ArmorRenderer;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.AirItem;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ElytraItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import org.jetbrains.annotations.NotNull;

public abstract class ModArmorItem
extends ArmorItem {
    private static final String FULL_SET_ID = "hadFullSet";
    protected int fullSetTick = 0;

    public ModArmorItem(ArmorMaterial pMaterial, ArmorItem.Type pType, Item.Properties pProperties) {
        super(pMaterial, pType, pProperties);
    }

    public boolean equals(ArmorItem item) {
        return this == item || item.m_40401_() == this.m_40401_();
    }

    public void m_6883_(@NotNull ItemStack stack, @NotNull Level level, @NotNull Entity entity, int slotID, boolean isSelected) {
        if (entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            CompoundTag tag = living.getPersistentData();
            if (this.isFullSetActive(living)) {
                if (this.m_40402_() == EquipmentSlot.CHEST) {
                    if (this.fullSetTick == 0) {
                        if (!level.f_46443_) {
                            this.initFullSetTick(stack, level, living);
                        }
                        tag.m_128379_(FULL_SET_ID, true);
                        tag.m_128359_("lastFullSet", this.m_40401_().m_6082_());
                    }
                    ++this.fullSetTick;
                    if (level.f_46443_) {
                        this.clientFullSetTick(stack, level, living);
                    } else {
                        this.fullSetTick(stack, level, living);
                    }
                }
            } else {
                if (living.getPersistentData().m_128471_(FULL_SET_ID)) {
                    if (!level.f_46443_) {
                        this.postFullSetTick(stack, level, living);
                    }
                    tag.m_128379_(FULL_SET_ID, false);
                }
                this.fullSetTick = 0;
            }
        }
    }

    public boolean isFullSetActive(LivingEntity living) {
        return ModArmorItem.isFullSetActive(living, this.m_40401_());
    }

    public static boolean isFullSetActive(LivingEntity living, ArmorMaterial materials) {
        ArmorItem armorItem;
        ArmorItem armorItem2;
        ArmorItem armorItem3;
        if (living == null) {
            return false;
        }
        Item item = living.m_6844_(EquipmentSlot.HEAD).m_41720_();
        ArmorItem head = item instanceof ArmorItem ? (armorItem3 = (ArmorItem)item) : null;
        Item chestPlate = living.m_6844_(EquipmentSlot.CHEST).m_41720_();
        if (chestPlate instanceof ElytraItem || chestPlate instanceof AirItem) {
            return false;
        }
        ArmorItem chest = (ArmorItem)living.m_6844_(EquipmentSlot.CHEST).m_41720_();
        Item item2 = living.m_6844_(EquipmentSlot.LEGS).m_41720_();
        ArmorItem legs = item2 instanceof ArmorItem ? (armorItem2 = (ArmorItem)item2) : null;
        Item item3 = living.m_6844_(EquipmentSlot.FEET).m_41720_();
        ArmorItem feet = item3 instanceof ArmorItem ? (armorItem = (ArmorItem)item3) : null;
        return head != null && legs != null && feet != null && head.m_40401_() == materials && chest.m_40401_() == materials && legs.m_40401_() == materials && feet.m_40401_() == materials;
    }

    protected void fullSetTick(ItemStack stack, Level level, LivingEntity living) {
    }

    protected void initFullSetTick(ItemStack stack, Level level, LivingEntity living) {
    }

    protected void postFullSetTick(ItemStack stack, Level level, LivingEntity living) {
    }

    protected void clientFullSetTick(ItemStack stack, Level level, LivingEntity living) {
    }

    public Multimap<Attribute, AttributeModifier> getAttributeMods(EquipmentSlot slot) {
        return null;
    }

    @NotNull
    public Multimap<Attribute, AttributeModifier> m_7167_(@NotNull EquipmentSlot slot) {
        HashMultimap builder = HashMultimap.create();
        builder.putAll(super.m_7167_(slot));
        if (this.getAttributeMods(slot) != null) {
            builder.putAll(this.getAttributeMods(slot));
        }
        return builder;
    }

    protected abstract boolean withCustomModel();

    protected ArmorRenderer<?> getRenderer(LivingEntity living, ItemStack stack, EquipmentSlot slot) {
        return null;
    }

    public void initializeClient(@NotNull Consumer<IClientItemExtensions> consumer) {
        if (!this.withCustomModel()) {
            return;
        }
        consumer.accept(new IClientItemExtensions(){

            @NotNull
            public HumanoidModel<?> getHumanoidArmorModel(LivingEntity living, ItemStack stack, EquipmentSlot slot, HumanoidModel<?> original) {
                HumanoidModel armorModel = new HumanoidModel(ModArmorItem.this.getRenderer(living, stack, slot).makeArmorParts(slot));
                armorModel.f_102817_ = living.m_6144_();
                armorModel.f_102609_ = original.f_102609_;
                armorModel.f_102610_ = living.m_6162_();
                return armorModel;
            }
        });
    }

    public static String makeCustomTextureLocation(String nameSpace, String id) {
        return new ResourceLocation(nameSpace, "textures/models/armor/custom/" + id + ".png").toString();
    }
}

