/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.item.loot_table.functions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.BiFunction;
import net.kapitencraft.kap_lib.io.serialization.JsonSerializer;
import net.kapitencraft.kap_lib.item.loot_table.IConditional;
import net.kapitencraft.kap_lib.item.loot_table.modifiers.ModLootModifier;
import net.kapitencraft.kap_lib.registry.ModLootItemFunctions;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class AttributeAmountModifierFunction
extends LootItemConditionalFunction
implements IConditional {
    private static final Codec<AttributeAmountModifierFunction> CODEC = RecordCodecBuilder.create(attributeAmountModifierFunctionInstance -> attributeAmountModifierFunctionInstance.group((App)ModLootModifier.LOOT_CONDITIONS_CODEC.fieldOf("conditions").forGetter(i -> i.f_80676_), (App)ForgeRegistries.ATTRIBUTES.getCodec().fieldOf("attribute").forGetter(i -> i.modifier), (App)Formulas.CODEC.fieldOf("formula").forGetter(i -> i.formula)).apply((Applicative)attributeAmountModifierFunctionInstance, AttributeAmountModifierFunction::new));
    private final Attribute modifier;
    private final Formulas formula;
    public static final JsonSerializer<AttributeAmountModifierFunction> SERIALIZER = new JsonSerializer<AttributeAmountModifierFunction>(CODEC);

    private AttributeAmountModifierFunction(LootItemCondition[] p_80678_, Attribute attribute, Formulas formula) {
        super(p_80678_);
        this.modifier = attribute;
        this.formula = formula;
    }

    public Attribute getModifier() {
        return this.modifier;
    }

    @NotNull
    protected ItemStack m_7372_(@NotNull ItemStack stack, LootContext lootContext) {
        Entity source = (Entity)lootContext.m_78953_(LootContextParams.f_81455_);
        if (source instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)source;
            double amount = living.m_21133_(this.modifier);
            return this.formula.provide(stack, amount);
        }
        return stack;
    }

    @Override
    public LootItemCondition[] getConditions() {
        return this.f_80676_;
    }

    @NotNull
    public LootItemFunctionType m_7162_() {
        return (LootItemFunctionType)ModLootItemFunctions.ATTRIBUTE_MODIFIER.get();
    }

    public static enum Formulas implements Formula,
    StringRepresentable
    {
        DEFAULT("default", (stack, d) -> stack.m_255036_((int)((double)stack.m_41613_() * (1.0 + d / 100.0))));

        public static final StringRepresentable.EnumCodec<Formulas> CODEC;
        private final String name;
        private final BiFunction<ItemStack, Double, ItemStack> provider;

        private Formulas(String name, BiFunction<ItemStack, Double, ItemStack> provider) {
            this.name = name;
            this.provider = provider;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public ItemStack provide(ItemStack stack, double d) {
            return this.provider.apply(stack, d);
        }

        public static Formulas byName(String name) {
            return (Formulas)CODEC.m_262792_(name, (Enum)DEFAULT);
        }

        @NotNull
        public String m_7912_() {
            return this.name;
        }

        static {
            CODEC = StringRepresentable.m_216439_(Formulas::values);
        }
    }

    public static interface Formula {
        public String getName();

        public ItemStack provide(ItemStack var1, double var2);
    }
}

