/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.helpers;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.kapitencraft.kap_lib.collection.MapStream;
import net.kapitencraft.kap_lib.helpers.CollectionHelper;
import net.kapitencraft.kap_lib.helpers.IOHelper;
import net.kapitencraft.kap_lib.io.JsonHelper;
import net.kapitencraft.kap_lib.io.StringSegment;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTagVisitor;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public class IOHelper {
    private static final String LENGTH_ID = "Length";
    private static final Logger LOGGER = LogUtils.getLogger();

    public static boolean checkForIntAbove0(CompoundTag tag, String name) {
        return tag.contains(name, 3) && tag.getInt(name) > 0;
    }

    public static boolean isTagEmpty(@Nullable CompoundTag tag) {
        return tag == null || tag.isEmpty();
    }

    public static float increaseFloatTagValue(CompoundTag tag, String name, float f) {
        float value = tag.getFloat(name) + f;
        tag.putFloat(name, value);
        return value;
    }

    public static <T> T orElse(DataResult<T> result, @NotNull Supplier<T> defaulted) {
        Optional optional = result.result();
        return optional.orElseGet(defaulted);
    }

    public static <T> T loadFile(File file, Codec<T> codec, Supplier<T> defaulted) {
        try {
            if (!file.exists()) {
                return defaulted.get();
            }
            return IOHelper.orElse(codec.parse((DynamicOps)JsonOps.INSTANCE, (Object)Streams.parse((JsonReader)IOHelper.createReader(file))), defaulted);
        }
        catch (IOException e) {
            LOGGER.warn("unable to load file: " + file.getPath());
            return defaulted.get();
        }
    }

    public static <T> T loadOrCreateFile(File file, Codec<T> codec, Supplier<T> defaulted) {
        try {
            if (!file.exists()) {
                IOHelper.saveFile(file, codec, defaulted.get());
                return defaulted.get();
            }
            return IOHelper.orElse(codec.parse((DynamicOps)JsonOps.INSTANCE, (Object)Streams.parse((JsonReader)IOHelper.createReader(file))), defaulted);
        }
        catch (IOException iOException) {
            return defaulted.get();
        }
    }

    private static void createFile(File file) {
        try {
            file.getParentFile().mkdirs();
            if (!file.exists()) {
                file.createNewFile();
            }
        }
        catch (IOException e) {
            LOGGER.warn("unable to create file '{}': {}", (Object)file.getName(), (Object)e.getMessage());
        }
    }

    private static JsonReader createReader(File file) throws FileNotFoundException {
        return new JsonReader((Reader)new FileReader(file));
    }

    public static <T> void saveFile(File file, Codec<T> codec, T in) {
        try {
            IOHelper.createFile(file);
            FileWriter writer = new FileWriter(file);
            writer.write(JsonHelper.GSON.toJson(IOHelper.orElse(codec.encodeStart((DynamicOps)JsonOps.INSTANCE, in), JsonObject::new)));
            writer.close();
        }
        catch (Exception e) {
            LOGGER.warn("unable to save file: {}", (Object)e.getMessage());
        }
    }

    public static int increaseIntegerTagValue(CompoundTag tag, String name, int i) {
        int value = tag.getInt(name) + i;
        tag.putInt(name, value);
        return value;
    }

    public static int increaseIntOnlyAbove0(CompoundTag tag, String name, int i) {
        if (IOHelper.checkForIntAbove0(tag, name)) {
            return IOHelper.increaseIntegerTagValue(tag, name, i);
        }
        return tag.getInt(name);
    }

    public static int reduceBy1(CompoundTag tag, String name) {
        return IOHelper.increaseIntOnlyAbove0(tag, name, -1);
    }

    @NotNull
    public static CompoundTag putHashMapTag(@NotNull HashMap<UUID, Integer> hashMap) {
        CompoundTag mapTag = new CompoundTag();
        List<Integer> IntArray = CollectionHelper.fromAny(hashMap.values());
        mapTag.put("Uuids", (Tag)IOHelper.putUuidList(CollectionHelper.fromAny(hashMap.keySet())));
        mapTag.putIntArray("Ints", IntArray);
        mapTag.putInt(LENGTH_ID, hashMap.size());
        return mapTag;
    }

    public static void injectCompoundTag(Entity toInject, CompoundTag tag) {
        CompoundTag data = toInject.getPersistentData();
        Set allKeys = tag.getAllKeys();
        allKeys.forEach(s -> {
            if (tag.get(s) != null) {
                Tag patt0$temp = tag.get(s);
                if (patt0$temp instanceof CompoundTag) {
                    CompoundTag cTag = (CompoundTag)patt0$temp;
                    IOHelper.injectCompoundTag(toInject, cTag);
                } else {
                    data.put(s, tag.get(s));
                }
            }
        });
    }

    public static String fromCompoundTag(CompoundTag tag) {
        return new StringTagVisitor().visit((Tag)tag);
    }

    public static Stream<CompoundTag> readCompoundList(CompoundTag tag, String name) {
        return IOHelper.readList(tag, name, CompoundTag.class, Function.identity(), 10);
    }

    public static <K, T extends Tag> Stream<K> readList(CompoundTag tag, String name, Class<T> tClass, Function<T, K> creator, int elementId) {
        ListTag listTag = tag.getList(name, elementId);
        return listTag.stream().filter(tClass::isInstance).map(tClass::cast).map(creator);
    }

    public static CompoundTag fromString(String s) {
        try {
            return new TagParser(new StringReader(s)).readStruct();
        }
        catch (CommandSyntaxException e) {
            LOGGER.warn("unable to read Tag '{}': {}", (Object)s, (Object)e.getMessage());
            return new CompoundTag();
        }
    }

    @NotNull
    public static HashMap<UUID, Integer> getHashMapTag(@Nullable CompoundTag tag) {
        HashMap<UUID, Integer> hashMap = new HashMap<UUID, Integer>();
        if (tag == null) {
            return hashMap;
        }
        int[] intArray = tag.getIntArray("Ints");
        UUID[] UuidArray = IOHelper.getUuidArray(tag.getCompound("Uuids"));
        if (UuidArray != null) {
            for (int i = 0; i < (intArray.length == UuidArray.length ? intArray.length : 0); ++i) {
                hashMap.put(UuidArray[i], intArray[i]);
            }
        }
        return hashMap;
    }

    public static UUID[] getUuidArray(CompoundTag arrayTag) {
        if (arrayTag.contains(LENGTH_ID)) {
            int length = arrayTag.getInt(LENGTH_ID);
            UUID[] array = new UUID[length];
            for (int i = 0; i < length; ++i) {
                array[i] = arrayTag.getUUID(String.valueOf(i));
            }
            return array;
        }
        LOGGER.warn("tried to load UUID Array from Tag but Tag isn`t Array Tag");
        return null;
    }

    public static CompoundTag putUuidList(List<UUID> list) {
        CompoundTag arrayTag = new CompoundTag();
        for (int i = 0; i < list.size(); ++i) {
            arrayTag.putUUID(String.valueOf(i), list.get(i));
        }
        arrayTag.putInt(LENGTH_ID, list.size());
        return arrayTag;
    }

    public static <K, V> ListTag writeMap(Map<K, V> map, DataWriter<K> keyWriter, DataWriter<V> valueWriter) {
        ListTag listTag = new ListTag();
        map.forEach((k, v) -> {
            CompoundTag tag = new CompoundTag();
            tag.put("Key", keyWriter.createData(k));
            tag.put("Value", valueWriter.createData(v));
            listTag.add((Object)tag);
        });
        return listTag;
    }

    public static CompoundTag getOrCreateCompound(CompoundTag tag, String name) {
        if (tag.contains(name, 10)) {
            return tag.getCompound(name);
        }
        CompoundTag data = new CompoundTag();
        tag.put(name, (Tag)data);
        return data;
    }

    public static ListTag getOrCreateList(CompoundTag tag, String name, int listType) {
        if (tag.contains(name, 9)) {
            return tag.getList(name, listType);
        }
        ListTag listTag = new ListTag();
        tag.put(name, (Tag)listTag);
        return listTag;
    }

    public static <K, V> MapStream<K, V> readMap(ListTag tag, BiFunction<CompoundTag, String, K> keyExtractor, BiFunction<CompoundTag, String, V> valueExtractor) {
        HashMap map = new HashMap();
        tag.stream().filter(CompoundTag.class::isInstance).map(CompoundTag.class::cast).forEach(tag1 -> map.put(keyExtractor.apply((CompoundTag)tag1, "Key"), valueExtractor.apply((CompoundTag)tag1, "Value")));
        return MapStream.of(map);
    }

    public static <K, V> JsonArray writeMap(Map<K, V> map, Function<K, JsonElement> keyMapper, Function<V, JsonElement> valueMapper) {
        JsonArray array = new JsonArray(map.size());
        map.forEach((k, v) -> {
            JsonObject object = new JsonObject();
            object.add("key", (JsonElement)keyMapper.apply(k));
            object.add("value", (JsonElement)valueMapper.apply(v));
        });
        return array;
    }

    public static <K, V> MapStream<K, V> readMap(JsonArray array, BiFunction<JsonObject, String, K> keyExtractor, BiFunction<JsonObject, String, V> valueExtractor) {
        HashMap map = new HashMap();
        JsonHelper.castToObjects((JsonArray)array).forEach(object -> map.put(keyExtractor.apply((JsonObject)object, "key"), valueExtractor.apply((JsonObject)object, "value")));
        return MapStream.of(map);
    }

    public static <K, V> MapStream<K, V> readMap(JsonArray array, Function<JsonElement, K> keyMapper, Function<JsonElement, V> valueMapper) {
        return IOHelper.readMap(array, (JsonObject object, String string) -> keyMapper.apply(object.get(string)), (JsonObject object, String string) -> valueMapper.apply(object.get(string)));
    }

    public static <T> ListTag writeList(List<T> list, Function<T, Tag> mapper) {
        ListTag tag = new ListTag();
        list.stream().map(mapper).forEach(arg_0 -> tag.add(arg_0));
        return tag;
    }

    public static List<File> listResources(File file) {
        if (!file.exists()) {
            return List.of();
        }
        if (!file.isDirectory()) {
            return List.of(file);
        }
        ArrayList<File> finals = new ArrayList<File>();
        ArrayList<File> queue = new ArrayList<File>();
        queue.add(file);
        while (!queue.isEmpty()) {
            if (((File)queue.get(0)).isDirectory()) {
                String[] childNames = ((File)queue.get(0)).list();
                if (childNames != null) {
                    for (String childName : childNames) {
                        queue.add(new File((File)queue.get(0), childName));
                    }
                }
            } else {
                finals.add((File)queue.get(0));
            }
            queue.remove(0);
        }
        return finals;
    }

    public static List<StringSegment> collectBracketContent(String in, String openRegex, String closeRegex) {
        ArrayList<StringSegment> strings = new ArrayList<StringSegment>();
        Matcher openMatcher = Pattern.compile(openRegex).matcher(in);
        Matcher closeMatcher = Pattern.compile(closeRegex).matcher(in);
        for (int i = 0; i < in.length(); ++i) {
            if (!openMatcher.find(i) || !closeMatcher.find(openMatcher.end())) continue;
            strings.add(StringSegment.fromString((int)openMatcher.start(), (int)closeMatcher.end(), (String)in));
        }
        return strings;
    }
}

