/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.io.serialization;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.function.Supplier;
import net.kapitencraft.kap_lib.helpers.IOHelper;
import net.kapitencraft.kap_lib.helpers.MiscHelper;
import org.jetbrains.annotations.NotNull;

public abstract class Serializer<T, K extends DynamicOps<T>, L> {
    private final K generator;
    private final Codec<L> codec;
    private final Supplier<L> defaulted;

    public Serializer(K generator, Codec<L> codec, Supplier<L> defaulted) {
        this.generator = generator;
        this.codec = codec;
        this.defaulted = defaulted;
    }

    abstract T getSerializeDefault();

    public T encode(@NotNull L value) {
        return (T)IOHelper.orElse(this.codec.encodeStart(this.generator, value), this::getSerializeDefault);
    }

    @Deprecated
    public L parse(T object) {
        if (object == null) {
            return this.defaulted.get();
        }
        return (L)IOHelper.orElse(this.codec.parse(this.generator, object), (Supplier)MiscHelper.nonNullOr(this.defaulted, () -> null));
    }

    public L parseOrThrow(T object) {
        DataResult result = this.codec.parse(this.generator, object);
        return (L)result.resultOrPartial().orElseThrow(NullPointerException::new);
    }

    public Codec<L> getCodec() {
        return this.codec;
    }
}

