/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.util.string_converter.converter;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.kapitencraft.kap_lib.KapLibMod;
import net.kapitencraft.kap_lib.util.string_converter.args.CalculationArgument;
import net.kapitencraft.kap_lib.util.string_converter.args.TransferArg;
import net.kapitencraft.kap_lib.util.string_converter.args.ValueArgument;
import net.kapitencraft.kap_lib.util.string_converter.param_storage.ParamStorage;

public abstract class TextConverter<T> {
    private final Function<String, T> creator;
    private final String args;

    protected TextConverter(Function<String, T> creator, String args) {
        this.creator = creator;
        this.args = args;
    }

    protected T createFromString(ParamStorage<T> storage, String s) {
        return storage.contains(s) ? storage.get(s) : this.creator.apply(s);
    }

    protected abstract CalculationArgument<T> getCalcArg(String var1);

    public String getArgs() {
        return this.args;
    }

    public String toString() {
        return "Converting: '" + this.args + "'";
    }

    public T transfer(ParamStorage<T> storage) {
        CalculationArgument<T> toMerge;
        int cycle;
        String[] toTransfer = this.args.split(" ");
        ArrayList<TransferArg<T>> args = new ArrayList<TransferArg<T>>();
        for (String value : toTransfer) {
            if (this.isArg(value)) {
                args.add(this.getCalcArg(value));
                continue;
            }
            args.add(new ValueArgument<T>(this.createFromString(storage, value)));
        }
        ArrayList<TransferArg<T>> currentArgs = TextConverter.copyOf(args);
        args.clear();
        for (cycle = 0; currentArgs.size() > 1 && cycle < 1000 && (toMerge = TextConverter.getNextArg(currentArgs)) != null; ++cycle) {
            int pos = currentArgs.indexOf(toMerge);
            ValueArgument firstArg = (ValueArgument)currentArgs.get(pos - 1);
            ValueArgument secondArg = (ValueArgument)currentArgs.get(pos + 1);
            ValueArgument<T> resultArg = ValueArgument.create(toMerge, firstArg, secondArg);
            TextConverter.removeAll(currentArgs, toMerge, firstArg, secondArg);
            currentArgs.add(pos - 1, resultArg);
        }
        if (cycle == 1000) {
            KapLibMod.LOGGER.warn("the converter failed to convert value from args: {}; out of time", args);
        }
        return ((TransferArg)currentArgs.get(0)).value();
    }

    protected abstract boolean isArg(String var1);

    @Nullable
    protected static <T> CalculationArgument<T> getNextArg(List<TransferArg<T>> list) {
        CalculationArgument firstArg = null;
        for (TransferArg<T> transferArg : list) {
            if (!(transferArg instanceof CalculationArgument)) continue;
            CalculationArgument mathArgument = (CalculationArgument)transferArg;
            if (mathArgument.isPreferred()) {
                return mathArgument;
            }
            if (firstArg != null) continue;
            firstArg = mathArgument;
        }
        return firstArg;
    }

    protected static <T> void removeAll(List<T> list, T ... ts) {
        for (T t : ts) {
            list.remove(t);
        }
    }

    protected static <T> ArrayList<T> copyOf(List<T> list) {
        return new ArrayList<T>(list);
    }
}

