/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.logging.LogUtils;
import java.io.File;
import java.text.DecimalFormat;
import net.kapitencraft.kap_lib.Markers;
import net.kapitencraft.kap_lib.advancement.ExtraCriterionTriggers;
import net.kapitencraft.kap_lib.client.enchantment_color.ConfigureEnchantmentColorsCommand;
import net.kapitencraft.kap_lib.client.overlay.OverlaysCommand;
import net.kapitencraft.kap_lib.commands.ClientTestCommand;
import net.kapitencraft.kap_lib.commands.ServerTestCommand;
import net.kapitencraft.kap_lib.config.ClientModConfig;
import net.kapitencraft.kap_lib.config.ServerModConfig;
import net.kapitencraft.kap_lib.crafting.ExtraRecipeTypes;
import net.kapitencraft.kap_lib.registry.ExtraAttributes;
import net.kapitencraft.kap_lib.registry.ExtraEnchantmentEffectComponents;
import net.kapitencraft.kap_lib.registry.ExtraLootItemConditions;
import net.kapitencraft.kap_lib.registry.ExtraLootModifiers;
import net.kapitencraft.kap_lib.registry.ExtraMobEffects;
import net.kapitencraft.kap_lib.registry.ExtraParticleTypes;
import net.kapitencraft.kap_lib.registry.ExtraRecipeSerializers;
import net.kapitencraft.kap_lib.registry.ModAttachmentTypes;
import net.kapitencraft.kap_lib.registry.TestCooldowns;
import net.kapitencraft.kap_lib.registry.TestItems;
import net.kapitencraft.kap_lib.registry.custom.BonusTypes;
import net.kapitencraft.kap_lib.registry.custom.CameraModifiers;
import net.kapitencraft.kap_lib.registry.custom.GlyphEffects;
import net.kapitencraft.kap_lib.registry.custom.Overlays;
import net.kapitencraft.kap_lib.registry.custom.RequirementTypes;
import net.kapitencraft.kap_lib.registry.custom.WearableSlots;
import net.kapitencraft.kap_lib.registry.custom.particle_animation.ActivationTriggers;
import net.kapitencraft.kap_lib.registry.custom.particle_animation.ElementTypes;
import net.kapitencraft.kap_lib.registry.custom.particle_animation.FinalizerTypes;
import net.kapitencraft.kap_lib.registry.custom.particle_animation.SpawnerTypes;
import net.kapitencraft.kap_lib.registry.custom.particle_animation.TerminatorTriggers;
import net.kapitencraft.kap_lib.registry.custom.spawn_table.SpawnEntityFunctions;
import net.kapitencraft.kap_lib.registry.custom.spawn_table.SpawnPoolEntries;
import net.kapitencraft.kap_lib.registry.vanilla.VanillaInventoryPages;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.loading.progress.StartupNotificationManager;
import net.neoforged.neoforge.client.event.RegisterClientCommandsEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.gametest.GameTestHooks;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforgespi.language.IModInfo;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.jetbrains.annotations.ApiStatus;
import org.slf4j.Logger;
import org.slf4j.Marker;

@Mod(value="kap_lib")
@ApiStatus.Internal
public class KapLibMod {
    public static final String MOD_ID = "kap_lib";
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final Marker MARKER = Markers.getMarker("KapLib");
    @ApiStatus.Internal
    public static final File ROOT = new File("./kap_lib");

    public static ResourceLocation res(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)path);
    }

    public KapLibMod(IEventBus modEventBus, ModContainer container) {
        ExtraAttributes.REGISTRY.register(modEventBus);
        ExtraLootModifiers.REGISTRY.register(modEventBus);
        ExtraLootItemConditions.REGISTRY.register(modEventBus);
        ExtraParticleTypes.REGISTRY.register(modEventBus);
        ExtraRecipeSerializers.REGISTRY.register(modEventBus);
        ExtraRecipeTypes.REGISTRY.register(modEventBus);
        ExtraMobEffects.REGISTRY.register(modEventBus);
        ExtraEnchantmentEffectComponents.REGISTRY.register(modEventBus);
        ExtraCriterionTriggers.REGISTRY.register(modEventBus);
        RequirementTypes.REGISTRY.register(modEventBus);
        BonusTypes.REGISTRY.register(modEventBus);
        GlyphEffects.REGISTRY.register(modEventBus);
        WearableSlots.REGISTRY.register(modEventBus);
        ElementTypes.REGISTRY.register(modEventBus);
        SpawnerTypes.REGISTRY.register(modEventBus);
        FinalizerTypes.REGISTRY.register(modEventBus);
        TerminatorTriggers.REGISTRY.register(modEventBus);
        ActivationTriggers.REGISTRY.register(modEventBus);
        CameraModifiers.REGISTRY.register(modEventBus);
        SpawnEntityFunctions.REGISTRY.register(modEventBus);
        SpawnPoolEntries.REGISTRY.register(modEventBus);
        Overlays.REGISTRY.register(modEventBus);
        ModAttachmentTypes.REGISTRY.register(modEventBus);
        VanillaInventoryPages.REGISTRY.register(modEventBus);
        if (GameTestHooks.isGametestEnabled()) {
            TestItems.REGISTRY.register(modEventBus);
            TestCooldowns.REGISTRY.register(modEventBus);
        }
        container.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ClientModConfig.SPEC);
        container.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)ServerModConfig.SPEC);
        NeoForge.EVENT_BUS.addListener(KapLibMod::registerClient);
        NeoForge.EVENT_BUS.addListener(KapLibMod::registerServer);
        NeoForgeMod.enableMergedAttributeTooltips();
        ArtifactVersion modVersion = ModList.get().getModContainerById(MOD_ID).map(ModContainer::getModInfo).map(IModInfo::getVersion).orElse(null);
        if (modVersion == null) {
            throw new IllegalStateException("KapLib version not found");
        }
        StartupNotificationManager.addModMessage((String)("KapLib Mod v" + String.valueOf(modVersion) + " loaded"));
        LOGGER.info(MARKER, "KapLib v{} loaded", (Object)modVersion);
    }

    public static String doubleFormat(double d) {
        return new DecimalFormat("#.##").format(d);
    }

    public static <T> DeferredRegister<T> registry(ResourceKey<Registry<T>> key) {
        return DeferredRegister.create(key, (String)MOD_ID);
    }

    @ApiStatus.Internal
    static void registerClient(RegisterClientCommandsEvent event) {
        CommandDispatcher dispatcher = event.getDispatcher();
        OverlaysCommand.register((CommandDispatcher<CommandSourceStack>)dispatcher);
        ClientTestCommand.register((CommandDispatcher<CommandSourceStack>)dispatcher);
        ConfigureEnchantmentColorsCommand.register((CommandDispatcher<CommandSourceStack>)dispatcher);
    }

    @ApiStatus.Internal
    static void registerServer(RegisterCommandsEvent event) {
        ServerTestCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }
}

