/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.client.cam.core;

import net.kapitencraft.kap_lib.client.cam.core.CameraData;
import net.kapitencraft.kap_lib.client.cam.core.TrackingShotData;
import net.kapitencraft.kap_lib.client.cam.modifiers.Modifier;
import net.minecraft.CrashReport;
import net.minecraft.ReportedException;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TrackingShot {
    private final TrackingShotData data;
    private Modifier modifier;
    private int tickCount;
    private int rotIndex;
    private int index;
    private int rotStartTick;
    private int posStartTick;

    public TrackingShot(TrackingShotData data) {
        this.data = data;
    }

    public static TrackingShotData.Builder builder() {
        return new TrackingShotData.Builder();
    }

    public void setup() {
        this.modifier = this.data.modifiers.get(0);
    }

    public void tick(CameraData camData) {
        try {
            int deltaTickTime = this.tickCount - this.posStartTick;
            this.modifier.modify(deltaTickTime, (double)deltaTickTime / (double)(this.data.times.get(this.posStartTick) - 1), camData);
            if (deltaTickTime >= this.data.times.get(this.index) && ++this.index < this.data.modifiers.size()) {
                this.modifier = this.data.modifiers.get(this.index);
                this.posStartTick = this.tickCount;
            }
            ++this.tickCount;
        }
        catch (Exception e) {
            CrashReport report = new CrashReport("Ticking TrackingShot", (Throwable)e);
            report.addCategory("Tracking Shot Data").setDetail("ModifierData", this.data.modifiers).setDetail("ModifierTimes", this.data.times).setDetail("Disable Shake", (Object)this.data.suppressShake);
            throw new ReportedException(report);
        }
    }

    boolean suppressesShake() {
        return this.data.suppressesShake();
    }

    public boolean done() {
        return this.index == this.data.modifiers.size();
    }
}

