/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.client.enchantment_color;

import java.util.ArrayList;
import java.util.List;
import net.kapitencraft.kap_lib.client.UsefulTextures;
import net.kapitencraft.kap_lib.client.enchantment_color.EnchantmentColor;
import net.kapitencraft.kap_lib.client.enchantment_color.EnchantmentColorManager;
import net.kapitencraft.kap_lib.client.enchantment_color.EnchantmentGroup;
import net.kapitencraft.kap_lib.client.enchantment_color.LevelRange;
import net.kapitencraft.kap_lib.client.widget.PositionedWidget;
import net.kapitencraft.kap_lib.client.widget.SelectChatColorWidget;
import net.kapitencraft.kap_lib.client.widget.SelectCountWidget;
import net.kapitencraft.kap_lib.client.widget.SelectEnumWidget;
import net.kapitencraft.kap_lib.client.widget.select.HolderByNameRegistryElementSelectorWidget;
import net.kapitencraft.kap_lib.config.ClientModConfig;
import net.kapitencraft.kap_lib.helpers.MathHelper;
import net.kapitencraft.kap_lib.util.range.simple.IntegerNumberRange;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.item.enchantment.Enchantment;
import org.jetbrains.annotations.Nullable;

public class ConfigureEnchantmentColorsScreen
extends Screen {
    private static final int ELEMENT_HEIGHT = 70;
    private static final int WIDTH = 404;
    private static final int HEIGHT = 186;
    private static final int SLIDER_WIDTH = 6;
    private static final MutableComponent ADD = Component.literal((String)"+");
    private static final MutableComponent ADD_HOVERED = Component.literal((String)"+").withStyle(ChatFormatting.BOLD);
    private final EnchantmentColorManager manager;
    private final List<ColorElement> elements = new ArrayList<ColorElement>();
    private int maxScroll;
    private float scrollY;
    private boolean scrolling;
    private int leftPos;
    private int topPos;
    private ColorElement active;
    @Nullable
    private PositionedWidget selector;

    protected ConfigureEnchantmentColorsScreen() {
        super((Component)Component.translatable((String)"cec.title"));
        this.manager = EnchantmentColorManager.getInstance();
        List<EnchantmentColor> colors = this.manager.getAllColors();
        colors.stream().map(x$0 -> new ColorElement((EnchantmentColor)x$0)).forEach(this.elements::add);
        this.recalculateScroll();
    }

    protected void init() {
        this.leftPos = (this.width - 404) / 2;
        this.topPos = (this.height - 186) / 2;
        super.init();
    }

    private void recalculateScroll() {
        this.maxScroll = Math.max(0, 72 * this.elements.size() - 172 + 8);
    }

    public void render(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        pGuiGraphics.fill(this.leftPos, this.topPos, this.leftPos + 404, this.topPos + 186, -12566464);
        pGuiGraphics.drawCenteredString(this.font, this.title, this.width / 2, this.topPos + 2, 0xFFFFFF);
        pGuiGraphics.fill(this.leftPos + 2, this.topPos + 12, this.leftPos + 404 - 2, this.topPos + 186 - 2, -11513776);
        pGuiGraphics.enableScissor(this.leftPos + 2, this.topPos + 12, this.leftPos + 404 - 2, this.topPos + 186 - 2);
        for (int i = 0; i < this.elements.size(); ++i) {
            double mouseRelativeX = pMouseX - this.leftPos - 2;
            double mouseRelativeY = (float)(pMouseY - (this.topPos + 12) - i * 72) - this.scrollY;
            this.elements.get(i).render(pGuiGraphics, 72 * i + (int)this.scrollY + 12, pPartialTick, mouseRelativeX, mouseRelativeY, this.getHoveredIndex(pMouseY) == i);
        }
        pGuiGraphics.drawCenteredString(this.font, (Component)(this.isAddElementHovered(pMouseX, pMouseY) ? ADD_HOVERED : ADD), this.width / 2, 72 * this.elements.size() + (int)this.scrollY + 12 + this.topPos, 0xFFFFFF);
        pGuiGraphics.disableScissor();
        if (this.shouldShowSlider(pMouseX, pMouseY)) {
            float percentage = -this.scrollY / (float)this.maxScroll;
            UsefulTextures.renderSliderWithLine(pGuiGraphics, 6, this.scrolling, percentage, this.leftPos + 404 - 2, this.topPos + 12, 172);
        }
        pGuiGraphics.pose().pushPose();
        pGuiGraphics.pose().translate(0.0f, 0.0f, 100.0f);
        if (this.selector != null) {
            this.selector.render(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        }
        pGuiGraphics.pose().popPose();
    }

    private boolean shouldShowSlider(double pMouseX, double pMouseY) {
        return this.scrolling || this.maxScroll > 0 && MathHelper.is2dBetween(pMouseX, pMouseY, this.leftPos + 404 - 2 - 6, this.topPos + 12, this.leftPos + 404 - 2, this.topPos + 186 - 2);
    }

    private boolean sliderHovered(double pMouseY) {
        float positionY = (float)(this.topPos + 12) + -this.scrollY * 164.5f / (float)this.maxScroll;
        return MathHelper.isBetween(pMouseY, positionY, (double)positionY + 7.5);
    }

    private boolean isAddElementHovered(double pMouseX, double pMouseY) {
        if (this.selector != null) {
            return false;
        }
        int yPos = 72 * this.elements.size() + (int)this.scrollY + 12 + this.topPos;
        return MathHelper.is2dBetween(pMouseX, pMouseY, this.width / 2 - 4, yPos, this.width / 2 + 4, yPos + 8);
    }

    public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
        if (this.selector != null) {
            return this.selector.mouseClicked(pMouseX, pMouseY, pButton);
        }
        if (this.shouldShowSlider(pMouseX, pMouseY)) {
            if (this.sliderHovered(pMouseY)) {
                this.scrolling = true;
            } else {
                double targetYPos = pMouseY - 3.75;
                this.scrollY = (float)(((double)(this.topPos + 12) - targetYPos) * (double)this.maxScroll / 164.5);
                this.scrollY = Mth.clamp((float)this.scrollY, (float)(-this.maxScroll), (float)0.0f);
            }
            return true;
        }
        int index = this.getHoveredIndex((int)pMouseY);
        if (index != -1) {
            ColorElement hovered = this.elements.get(index);
            hovered.mouseClicked(pMouseX - (double)this.leftPos - 2.0, pMouseY - (double)(this.topPos + 12) - (double)(index * 72) - (double)this.scrollY, pButton);
            this.active = hovered;
            return true;
        }
        if (this.isAddElementHovered(pMouseX, pMouseY)) {
            this.elements.add(new ColorElement(EnchantmentColor.create(I18n.get((String)"enchantment_colors.by_id", (Object[])new Object[]{this.elements.size() + 1}), new ArrayList<Holder<Enchantment>>(), new ArrayList<EnchantmentGroup>(), null, Style.EMPTY)));
            this.recalculateScroll();
        }
        return false;
    }

    public boolean mouseReleased(double pMouseX, double pMouseY, int pButton) {
        if (this.selector != null) {
            return this.selector.mouseReleased(pMouseX, pMouseY, pButton);
        }
        this.active = null;
        this.scrolling = false;
        return super.mouseReleased(pMouseX, pMouseY, pButton);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (this.selector != null) {
            return this.selector.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
        }
        if (MathHelper.is2dBetween(mouseX, mouseY, this.leftPos + 2, this.topPos + 12, this.leftPos + 404 - 2, this.topPos + 186 - 2)) {
            this.scrollY += (float)((int)(scrollY * ClientModConfig.getScrollScale()));
            this.scrollY = Mth.clamp((float)this.scrollY, (float)(-this.maxScroll), (float)0.0f);
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    public boolean mouseDragged(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        if (this.selector != null) {
            return this.selector.mouseDragged(pMouseX, pMouseY, pButton, pDragX, pDragY);
        }
        if (this.scrolling) {
            this.scrollY = (float)(Mth.clamp((double)(pMouseY - (double)(this.topPos + 12)), (double)0.0, (double)172.0) * (double)(-this.maxScroll) / 172.0);
        }
        return super.mouseDragged(pMouseX, pMouseY, pButton, pDragX, pDragY);
    }

    private ColorElement getForYPos(int y) {
        int hovered = this.getHoveredIndex(y);
        return hovered == -1 ? null : this.elements.get(hovered);
    }

    private int getHoveredIndex(int y) {
        if (this.selector != null) {
            return -1;
        }
        int index = (this.topPos + (int)this.scrollY + 12 - y) / -72;
        return index < 0 || index >= this.elements.size() ? -1 : index;
    }

    public void onClose() {
        this.manager.save(this.elements.stream().map(ColorElement::color).toList());
        super.onClose();
    }

    public boolean keyPressed(int pKeyCode, int pScanCode, int pModifiers) {
        if (pKeyCode == 256) {
            if (this.selector != null) {
                this.selector = null;
            } else {
                this.onClose();
            }
            return true;
        }
        return false;
    }

    private class ColorElement {
        private String name;
        private SelectChatColorWidget.ColorType colorType;
        @Nullable
        private LevelRange levelRange;
        private boolean bold;
        private boolean underlined;
        private boolean italic;
        private final List<Holder<Enchantment>> enchantments;
        private final List<EnchantmentGroup> groups;

        private ColorElement(EnchantmentColor color) {
            this.colorType = SelectChatColorWidget.getColor(color);
            Style style = color.targetStyle();
            this.bold = style.isBold();
            this.underlined = style.isUnderlined();
            this.italic = style.isItalic();
            this.levelRange = color.levelRange();
            this.name = color.name();
            this.enchantments = color.elements();
            this.groups = color.groups();
        }

        public void render(GuiGraphics guiGraphics, int yOffset, float pPartialTick, double mouseRelativeX, double mouseRelativeY, boolean hovered) {
            int yPos = ConfigureEnchantmentColorsScreen.this.topPos + yOffset;
            guiGraphics.fill(ConfigureEnchantmentColorsScreen.this.leftPos + 3, yPos, ConfigureEnchantmentColorsScreen.this.leftPos + 404 - 3, yPos + 70, hovered ? -7237231 : -7829368);
            guiGraphics.drawString(ConfigureEnchantmentColorsScreen.this.font, (Component)Component.literal((String)this.name).withStyle(new ChatFormatting[]{ChatFormatting.BOLD, ChatFormatting.UNDERLINE}), ConfigureEnchantmentColorsScreen.this.leftPos + 7, yPos + 1, 0xFFFFFF);
            guiGraphics.fill(ConfigureEnchantmentColorsScreen.this.leftPos + 5, yPos + 10, ConfigureEnchantmentColorsScreen.this.leftPos + 80, yPos + 60, -12566464);
            guiGraphics.enableScissor(ConfigureEnchantmentColorsScreen.this.leftPos + 5, yPos + 10, ConfigureEnchantmentColorsScreen.this.leftPos + 80, yPos + 60);
            for (int i = 0; i < this.enchantments.size(); ++i) {
                Holder<Enchantment> enchantment = this.enchantments.get(i);
                guiGraphics.drawString(ConfigureEnchantmentColorsScreen.this.font, (Component)Component.translatable((String)Util.makeDescriptionId((String)"enchantment", (ResourceLocation)enchantment.getKey().location())), ConfigureEnchantmentColorsScreen.this.leftPos + 6, yPos + 11 + i * 10, 0xFFFFFF);
                boolean enchantmentHovered = MathHelper.is2dBetween(mouseRelativeX, mouseRelativeY, 5, 11 + i * 10, 80, 21 + i * 10);
                if (!enchantmentHovered) continue;
                guiGraphics.pose().pushPose();
                guiGraphics.pose().translate(0.0f, 0.0f, 100.0f);
                UsefulTextures.renderCross(guiGraphics, ConfigureEnchantmentColorsScreen.this.leftPos + 71, yPos + 11 + i * 10, 8);
                guiGraphics.pose().popPose();
            }
            guiGraphics.drawString(ConfigureEnchantmentColorsScreen.this.font, (Component)(this.isEnchantmentAddHovered(mouseRelativeX, mouseRelativeY) ? ADD_HOVERED : ADD), ConfigureEnchantmentColorsScreen.this.leftPos + 6, yPos + 11 + this.enchantments.size() * 10, 0xFFFFFF);
            guiGraphics.disableScissor();
            guiGraphics.fill(ConfigureEnchantmentColorsScreen.this.leftPos + 81, yPos + 10, ConfigureEnchantmentColorsScreen.this.leftPos + 161, yPos + 60, -12566464);
            guiGraphics.enableScissor(ConfigureEnchantmentColorsScreen.this.leftPos + 81, yPos + 10, ConfigureEnchantmentColorsScreen.this.leftPos + 161, yPos + 60);
            int groupCount = this.groups.size();
            for (int i = 0; i < groupCount; ++i) {
                EnchantmentGroup group = this.groups.get(i);
                guiGraphics.drawString(ConfigureEnchantmentColorsScreen.this.font, group.getName(), ConfigureEnchantmentColorsScreen.this.leftPos + 82, yPos + 11 + i * 10, 0xFFFFFF);
                boolean groupHovered = MathHelper.is2dBetween(mouseRelativeX, mouseRelativeY, 81, 11 + i * 10, 161, 21 + i * 10);
                if (!groupHovered) continue;
                UsefulTextures.renderCross(guiGraphics, ConfigureEnchantmentColorsScreen.this.leftPos + 152, yPos + 11 + i * 10, 8);
            }
            if (groupCount < EnchantmentGroup.values().length) {
                guiGraphics.drawString(ConfigureEnchantmentColorsScreen.this.font, (Component)(this.isGroupAddHovered(mouseRelativeX, mouseRelativeY) ? ADD_HOVERED : ADD), ConfigureEnchantmentColorsScreen.this.leftPos + 82, yPos + 11 + groupCount * 10, 0xFFFFFF);
            }
            guiGraphics.disableScissor();
            boolean levelCheckActive = this.levelRange != null;
            UsefulTextures.renderCheckBoxWithText(guiGraphics, ConfigureEnchantmentColorsScreen.this.leftPos + 165, yPos + 11, -10461088, levelCheckActive, ConfigureEnchantmentColorsScreen.this.font, -1, (Component)Component.translatable((String)"cec.enable_level"));
            UsefulTextures.renderCheckBoxWithText(guiGraphics, ConfigureEnchantmentColorsScreen.this.leftPos + 165, yPos + 23, -10461088, levelCheckActive && this.levelRange.isMaxLevelRelative(), ConfigureEnchantmentColorsScreen.this.font, levelCheckActive ? -1 : -12566464, (Component)Component.translatable((String)"cec.relative"), levelCheckActive);
            guiGraphics.drawString(ConfigureEnchantmentColorsScreen.this.font, (Component)Component.translatable((String)"cec.min_level"), ConfigureEnchantmentColorsScreen.this.leftPos + 165, yPos + 34, levelCheckActive ? -1 : -12566464, levelCheckActive);
            guiGraphics.drawString(ConfigureEnchantmentColorsScreen.this.font, levelCheckActive ? String.valueOf(this.levelRange.getMin()) : "0", ConfigureEnchantmentColorsScreen.this.leftPos + 165, yPos + 45, levelCheckActive ? -1 : -12566464, levelCheckActive);
            guiGraphics.drawString(ConfigureEnchantmentColorsScreen.this.font, (Component)Component.translatable((String)"cec.max_level"), ConfigureEnchantmentColorsScreen.this.leftPos + 190, yPos + 34, levelCheckActive ? -1 : -12566464, levelCheckActive);
            guiGraphics.drawString(ConfigureEnchantmentColorsScreen.this.font, levelCheckActive ? String.valueOf(this.levelRange.getMax()) : "0", ConfigureEnchantmentColorsScreen.this.leftPos + 190, yPos + 45, levelCheckActive ? -1 : -12566464, levelCheckActive);
            UsefulTextures.renderCheckBoxWithText(guiGraphics, ConfigureEnchantmentColorsScreen.this.leftPos + 280, yPos + 11, -10461088, this.bold, ConfigureEnchantmentColorsScreen.this.font, -1, (Component)Component.translatable((String)"cec.style.bold").withStyle(ChatFormatting.BOLD));
            UsefulTextures.renderCheckBoxWithText(guiGraphics, ConfigureEnchantmentColorsScreen.this.leftPos + 280, yPos + 23, -10461088, this.underlined, ConfigureEnchantmentColorsScreen.this.font, -1, (Component)Component.translatable((String)"cec.style.underlined").withStyle(ChatFormatting.UNDERLINE));
            UsefulTextures.renderCheckBoxWithText(guiGraphics, ConfigureEnchantmentColorsScreen.this.leftPos + 280, yPos + 35, -10461088, this.italic, ConfigureEnchantmentColorsScreen.this.font, -1, (Component)Component.translatable((String)"cec.style.italic").withStyle(ChatFormatting.ITALIC));
            this.colorType.render(guiGraphics, ConfigureEnchantmentColorsScreen.this.leftPos + 279, yPos + 46, 10);
            guiGraphics.drawString(ConfigureEnchantmentColorsScreen.this.font, (Component)Component.translatable((String)"cec.style.color"), ConfigureEnchantmentColorsScreen.this.leftPos + 291, yPos + 47, -16);
            UsefulTextures.renderCross(guiGraphics, ConfigureEnchantmentColorsScreen.this.leftPos + 404 - 13, yPos + 1, 8);
        }

        public void mouseClicked(double relativeX, double relativeY, int code) {
            if (MathHelper.is2dBetween(relativeX, relativeY, 389, 1, 397, 9)) {
                ConfigureEnchantmentColorsScreen.this.elements.remove(this);
                ConfigureEnchantmentColorsScreen.this.recalculateScroll();
            } else if (MathHelper.is2dBetween(relativeX, relativeY, 163, 10, 173, 20)) {
                this.toggleLevelReq();
            } else if (this.isEnchantmentAddHovered(relativeX, relativeY)) {
                ConfigureEnchantmentColorsScreen.this.active = this;
                ConfigureEnchantmentColorsScreen.this.selector = new HolderByNameRegistryElementSelectorWidget(ConfigureEnchantmentColorsScreen.this.leftPos + 90, ConfigureEnchantmentColorsScreen.this.topPos + 20, 224, 146, (Component)Component.translatable((String)"cec.select_enchantment"), ConfigureEnchantmentColorsScreen.this.font, Minecraft.getInstance().getConnection().registryAccess().registryOrThrow(Registries.ENCHANTMENT), this.enchantments::add, objectHolder -> Util.makeDescriptionId((String)"enchantment", (ResourceLocation)objectHolder.getKey().location()));
            } else if (this.isGroupAddHovered(relativeX, relativeY)) {
                ArrayList<EnchantmentGroup> groupValues = new ArrayList<EnchantmentGroup>(List.of(EnchantmentGroup.values()));
                groupValues.removeAll(this.groups);
                ConfigureEnchantmentColorsScreen.this.selector = new SelectEnumWidget<EnchantmentGroup>(ConfigureEnchantmentColorsScreen.this.leftPos + 152, ConfigureEnchantmentColorsScreen.this.topPos + 53, 100, 80, ConfigureEnchantmentColorsScreen.this.font, groupValues, EnchantmentGroup::getName, this::addGroup, (Component)Component.translatable((String)"cec.select_group"));
            } else if (MathHelper.is2dBetween(relativeX, relativeY, 70, 10, 80, 60)) {
                int id = (int)((relativeY - 11.0) / 10.0);
                if (id < this.enchantments.size()) {
                    this.enchantments.remove(id);
                }
            } else if (MathHelper.is2dBetween(relativeX, relativeY, 152, 10, 161, 60)) {
                int id = (int)((relativeY - 11.0) / 10.0);
                if (id < this.groups.size()) {
                    this.groups.remove(id);
                }
            } else if (MathHelper.is2dBetween(relativeX, relativeY, 280, 11, 290, 21)) {
                this.bold = !this.bold;
            } else if (MathHelper.is2dBetween(relativeX, relativeY, 280, 23, 290, 33)) {
                this.underlined = !this.underlined;
            } else if (MathHelper.is2dBetween(relativeX, relativeY, 280, 35, 290, 45)) {
                this.italic = !this.italic;
            } else if (MathHelper.is2dBetween(relativeX, relativeY, 280, 47, 290, 57)) {
                ConfigureEnchantmentColorsScreen.this.selector = new SelectChatColorWidget(ConfigureEnchantmentColorsScreen.this.leftPos + 178, ConfigureEnchantmentColorsScreen.this.topPos + 56, this::setColor, (Component)Component.translatable((String)"cec.select_color"), ConfigureEnchantmentColorsScreen.this.font, this.colorType);
            } else if (this.levelRange != null) {
                if (MathHelper.is2dBetween(relativeX, relativeY, 163, 22, 173, 32)) {
                    this.levelRange = new LevelRange(this.levelRange.getMin(), this.levelRange.getMax(), !this.levelRange.isMaxLevelRelative());
                } else if (MathHelper.is2dBetween(relativeX, relativeY, 165, 43, 185, 53)) {
                    if (this.levelRange.getMin() == this.levelRange.getMax() && !this.levelRange.isMaxLevelRelative()) {
                        return;
                    }
                    ConfigureEnchantmentColorsScreen.this.selector = new SelectCountWidget(ConfigureEnchantmentColorsScreen.this.leftPos + 102, ConfigureEnchantmentColorsScreen.this.topPos + 43, 200, ConfigureEnchantmentColorsScreen.this.font, this.levelRange.getMin(), this::setMinLevel, new IntegerNumberRange(-255, this.levelRange.getMax()), (Component)Component.translatable((String)"cec.select_level_bound.min"));
                } else if (MathHelper.is2dBetween(relativeX, relativeY, 190, 43, 210, 53)) {
                    ConfigureEnchantmentColorsScreen.this.selector = new SelectCountWidget(ConfigureEnchantmentColorsScreen.this.leftPos + 102, ConfigureEnchantmentColorsScreen.this.topPos + 43, 200, ConfigureEnchantmentColorsScreen.this.font, this.levelRange.getMax(), this::setMaxLevel, new IntegerNumberRange(this.levelRange.getMin(), 255), (Component)Component.translatable((String)"cec.select_level_bound.max"));
                }
            }
        }

        private void addGroup(EnchantmentGroup enchantmentGroup) {
            this.groups.add(enchantmentGroup);
            ConfigureEnchantmentColorsScreen.this.selector = null;
        }

        private void setColor(SelectChatColorWidget.ColorType colorType) {
            this.colorType = colorType;
        }

        private boolean isEnchantmentAddHovered(double relativeX, double relativeY) {
            if (ConfigureEnchantmentColorsScreen.this.selector != null) {
                return false;
            }
            int enchantmentAddY = 11 + this.enchantments.size() * 10;
            return MathHelper.is2dBetween(relativeX, relativeY, 4, enchantmentAddY, 12, enchantmentAddY + 8);
        }

        private boolean isGroupAddHovered(double relativeX, double relativeY) {
            if (ConfigureEnchantmentColorsScreen.this.selector != null) {
                return false;
            }
            int groupCount = this.groups.size();
            return groupCount < EnchantmentGroup.values().length && MathHelper.is2dBetween(relativeX, relativeY, 80, 11 + groupCount * 10, 88, 19 + groupCount * 10);
        }

        private EnchantmentColor color() {
            Style style = this.colorType.getStyle().withBold(Boolean.valueOf(this.bold)).withUnderlined(Boolean.valueOf(this.underlined)).withItalic(Boolean.valueOf(this.italic));
            return EnchantmentColor.create(this.name, this.enchantments, this.groups, this.levelRange, style);
        }

        public void toggleLevelReq() {
            this.levelRange = this.levelRange != null ? null : new LevelRange(0, 0, false);
        }

        public void setMinLevel(int min) {
            if (this.levelRange != null) {
                this.levelRange = this.levelRange.withMin(min);
            }
        }

        public void setMaxLevel(int max) {
            if (this.levelRange != null) {
                this.levelRange = this.levelRange.withMax(max);
            }
        }
    }
}

