/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.client.particle.animation.spawners;

import net.kapitencraft.kap_lib.client.particle.animation.core.ParticleSpawnSink;
import net.kapitencraft.kap_lib.client.particle.animation.spawners.Spawner;
import net.kapitencraft.kap_lib.client.particle.animation.spawners.VisibleSpawner;
import net.kapitencraft.kap_lib.helpers.ClientHelper;
import net.kapitencraft.kap_lib.helpers.MathHelper;
import net.kapitencraft.kap_lib.registry.custom.particle_animation.SpawnerTypes;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class EntityBBSpawner
extends VisibleSpawner {
    private final int targetId;
    private final boolean onlyOutline;
    private final float sizeXScale;
    private final float sizeYScale;
    private final int perTick;

    protected EntityBBSpawner(ParticleOptions particle, int targetId, boolean onlyOutline, float sizeXScale, float sizeYScale, int perTick) {
        super(particle);
        this.targetId = targetId;
        this.onlyOutline = onlyOutline;
        this.sizeXScale = sizeXScale;
        this.sizeYScale = sizeYScale;
        this.perTick = perTick;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public void spawn(ParticleSpawnSink sink) {
        Entity target = ClientHelper.getEntity(this.targetId);
        float bbRadius = target.getBbWidth() / 2.0f;
        AABB box = target.getBoundingBox();
        for (int i = 0; i < this.perTick; ++i) {
            Vec3 pos = MathHelper.randomIn(sink.random, box);
            if (this.onlyOutline) {
                float c = sink.random.nextFloat();
                pos = c < 0.33333334f ? (c < 0.16666667f ? pos.with(Direction.Axis.X, box.minX) : pos.with(Direction.Axis.X, box.maxX)) : (c < 0.6666667f ? ((double)c < 0.5 ? pos.with(Direction.Axis.Y, box.minY) : pos.with(Direction.Axis.Y, box.maxY)) : (c < 0.8333333f ? pos.with(Direction.Axis.Z, box.minZ) : pos.with(Direction.Axis.Z, box.maxZ)));
            }
            sink.accept(this.particle, pos);
        }
    }

    @NotNull
    public Type getType() {
        return SpawnerTypes.ENTITY_BB.get();
    }

    public static class Builder
    extends VisibleSpawner.Builder<Builder> {
        private Entity target;
        private boolean onlyOutline;
        private float xScale = 1.0f;
        private float yScale = 1.0f;
        private int perTick;

        public Builder target(Entity target) {
            this.target = target;
            return this;
        }

        public Builder onlyOutline() {
            this.onlyOutline = true;
            return this;
        }

        public Builder scaleX(float xScale) {
            this.xScale *= xScale;
            return this;
        }

        public Builder scaleY(float yScale) {
            this.yScale *= yScale;
            return this;
        }

        @Override
        public VisibleSpawner build() {
            return new EntityBBSpawner(this.particle, this.target.getId(), this.onlyOutline, this.xScale, this.yScale, this.perTick);
        }

        public Builder perTick(int perTick) {
            this.perTick = perTick;
            return this;
        }
    }

    public static class Type
    implements Spawner.Type<EntityBBSpawner> {
        private static final StreamCodec<? super RegistryFriendlyByteBuf, EntityBBSpawner> STREAM_CODEC = StreamCodec.composite((StreamCodec)ParticleTypes.STREAM_CODEC, s -> s.particle, (StreamCodec)ByteBufCodecs.INT, s -> s.targetId, (StreamCodec)ByteBufCodecs.BOOL, s -> s.onlyOutline, (StreamCodec)ByteBufCodecs.FLOAT, s -> Float.valueOf(s.sizeXScale), (StreamCodec)ByteBufCodecs.FLOAT, s -> Float.valueOf(s.sizeYScale), (StreamCodec)ByteBufCodecs.INT, s -> s.perTick, EntityBBSpawner::new);

        @Override
        public StreamCodec<? super RegistryFriendlyByteBuf, EntityBBSpawner> codec() {
            return STREAM_CODEC;
        }
    }
}

