/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.client.particle.animation.spawners;

import net.kapitencraft.kap_lib.client.particle.animation.core.ParticleSpawnSink;
import net.kapitencraft.kap_lib.client.particle.animation.spawners.Spawner;
import net.kapitencraft.kap_lib.client.particle.animation.spawners.VisibleSpawner;
import net.kapitencraft.kap_lib.client.util.pos_target.PositionTarget;
import net.kapitencraft.kap_lib.registry.custom.particle_animation.SpawnerTypes;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import org.jetbrains.annotations.NotNull;

public class TrackingSpawner
extends VisibleSpawner {
    private final PositionTarget target;

    public TrackingSpawner(ParticleOptions particle, PositionTarget target) {
        super(particle);
        this.target = target;
    }

    public String toString() {
        return "TrackingSpawner[" + String.valueOf(this.target) + "]";
    }

    @Override
    public void spawn(ParticleSpawnSink sink) {
        sink.accept(this.particle, this.target.get());
    }

    @NotNull
    public Type getType() {
        return SpawnerTypes.TRACKING.get();
    }

    public static class Type
    implements Spawner.Type<TrackingSpawner> {
        private static final StreamCodec<? super RegistryFriendlyByteBuf, TrackingSpawner> STREAM_CODEC = StreamCodec.composite((StreamCodec)ParticleTypes.STREAM_CODEC, s -> s.particle, PositionTarget.STREAM_CODEC, s -> s.target, TrackingSpawner::new);

        @Override
        public StreamCodec<? super RegistryFriendlyByteBuf, TrackingSpawner> codec() {
            return STREAM_CODEC;
        }
    }

    public static class Builder
    extends VisibleSpawner.Builder<Builder> {
        private PositionTarget target;

        public Builder target(PositionTarget target) {
            this.target = target;
            return this;
        }

        @Override
        public VisibleSpawner build() {
            return new TrackingSpawner(this.particle, this.target);
        }
    }
}

