/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.client.widget.select;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.kapitencraft.kap_lib.client.UsefulTextures;
import net.kapitencraft.kap_lib.client.widget.PositionedWidget;
import net.kapitencraft.kap_lib.config.ClientModConfig;
import net.kapitencraft.kap_lib.helpers.MathHelper;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.Registry;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

public abstract class SelectRegistryElementWidget<T>
extends PositionedWidget {
    private static final Component SELECT_PANEL = Component.translatable((String)"mco.template.button.select");
    private final Component title;
    protected final Font font;
    private final int titleWidth;
    protected float scroll;
    protected boolean scrolling;
    protected int maxScroll;
    protected final List<T> allElements = new ArrayList<T>();
    protected T selected;
    private final Consumer<T> valueSink;

    protected SelectRegistryElementWidget(int x, int y, int width, int height, Component title, Font font, Registry<T> registry, Consumer<T> valueSink) {
        super(x, y, width, height);
        for (Object element : registry) {
            this.allElements.add(element);
        }
        this.title = title;
        this.font = font;
        this.valueSink = valueSink;
        this.titleWidth = this.font.width((FormattedText)SELECT_PANEL);
        this.maxScroll = this.size() - (height - 22);
        this.scroll = 0.0f;
    }

    public final void render(@NotNull GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        int widgetMiddle = this.x + this.width / 2;
        pGuiGraphics.fill(this.x, this.y, this.getMaxX(), this.getMaxY(), -16185079);
        pGuiGraphics.drawCenteredString(this.font, this.title, widgetMiddle, this.y + 1, 0xFFFFFF);
        pGuiGraphics.enableScissor(this.x + 1, this.y + 11, this.getMaxX() - 1, this.getMaxY() - 11);
        pGuiGraphics.pose().pushPose();
        pGuiGraphics.pose().translate((float)(this.x + 1), (float)(this.y + 11), 0.0f);
        this.renderInternal(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        pGuiGraphics.pose().popPose();
        UsefulTextures.renderSliderWithLine(pGuiGraphics, 4, true, this.scroll / (float)(-this.maxScroll), this.getMaxX() - 1, this.y + 11, this.height - 22);
        pGuiGraphics.disableScissor();
        pGuiGraphics.drawString(this.font, SELECT_PANEL, this.getMaxX() - (this.titleWidth + 2), this.getMaxY() - 10, 0xFFFFFF);
    }

    protected abstract int getHoveredIndex(double var1, double var3);

    protected abstract void renderInternal(GuiGraphics var1, int var2, int var3, float var4);

    public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
        int widgetMiddle = this.x + this.width / 2;
        int selectPos = this.getMaxX() - (this.titleWidth + 2);
        if (MathHelper.is2dBetween(pMouseX, pMouseY, this.getMaxX() - 7, this.y + 11, this.getMaxX() - 1, this.getMaxY() - 11)) {
            if (this.sliderHovered(pMouseY)) {
                this.scrolling = true;
            } else {
                double targetYPos = pMouseY - 2.5;
                this.scroll = (float)(((double)(this.y + 11) - targetYPos) * (double)this.maxScroll / (double)(this.height - 27));
                this.scroll = Mth.clamp((float)this.scroll, (float)(-this.maxScroll), (float)0.0f);
            }
            return true;
        }
        if (MathHelper.is2dBetween(pMouseX, pMouseY, selectPos - 1, this.getMaxY() - 10, selectPos + this.titleWidth + 1, this.getMaxY())) {
            if (this.selected != null) {
                this.valueSink.accept(this.selected);
                this.selected = null;
                return true;
            }
        } else if (this.getHoveredIndex(pMouseX, pMouseY) != -1) {
            this.selected = this.allElements.get(this.getHoveredIndex(pMouseX, pMouseY));
            return true;
        }
        return super.mouseClicked(pMouseX, pMouseY, pButton);
    }

    private boolean sliderHovered(double pMouseY) {
        float positionY = (float)(this.y + 11) + -this.scroll * (float)(this.height - 27) / (float)this.maxScroll;
        return MathHelper.isBetween(pMouseY, positionY, positionY + 5.0f);
    }

    protected abstract int size();

    public boolean mouseScrolled(double pMouseX, double pMouseY, double scrollX, double scrollY) {
        if (MathHelper.is2dBetween(pMouseX, pMouseY, this.x + 1, this.y + 11, this.getMaxX() - 1, this.getMaxY() - 11)) {
            this.scroll += (float)(scrollY * ClientModConfig.getScrollScale());
            this.scroll = Mth.clamp((float)this.scroll, (float)(-this.maxScroll), (float)0.0f);
            return true;
        }
        return super.mouseScrolled(pMouseX, pMouseY, scrollX, scrollY);
    }

    public boolean mouseDragged(double pMouseX, double pMouseY, int pButton, double pDragX, double pDragY) {
        if (this.scrolling) {
            this.scroll = (float)(Mth.clamp((double)(pMouseY - (double)(this.y + 11)), (double)0.0, (double)(this.height - 11)) * (double)(-this.maxScroll) / (double)(this.height - 11));
        }
        return super.mouseDragged(pMouseX, pMouseY, pButton, pDragX, pDragY);
    }

    public boolean mouseReleased(double pMouseX, double pMouseY, int pButton) {
        if (this.scrolling) {
            this.scrolling = false;
        }
        return super.mouseReleased(pMouseX, pMouseY, pButton);
    }
}

