/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.io;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.stream.Stream;
import net.kapitencraft.kap_lib.io.serialization.ExtraJsonSerializers;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public interface JsonHelper {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public static Stream<JsonObject> castToObjects(JsonArray array) {
        return array.asList().stream().filter(JsonElement::isJsonObject).map(JsonElement::getAsJsonObject);
    }

    public static Vec3 getAsVec3(JsonObject pObject, String id) {
        return (Vec3)ExtraJsonSerializers.VEC_3.parse((Vec3)pObject.get(id));
    }

    @Nullable
    public static Boolean getAsOptionalBool(JsonObject pObject, String name) {
        return pObject.has(name) ? Boolean.valueOf(GsonHelper.getAsBoolean((JsonObject)pObject, (String)name)) : null;
    }

    @Nullable
    public static Integer getAsOptionalInt(JsonObject pObject, String name) {
        return pObject.has(name) ? Integer.valueOf(GsonHelper.getAsInt((JsonObject)pObject, (String)name)) : null;
    }

    public static void addOptionalBool(JsonObject pJson, String name, Boolean val) {
        if (val != null) {
            pJson.addProperty(name, val);
        }
    }

    public static void addOptionalInt(JsonObject pJson, String name, Integer val) {
        if (val != null) {
            pJson.addProperty(name, (Number)val);
        }
    }
}

