package net.kapitencraft.kap_lib.registry.custom.core;

import com.mojang.serialization.MapCodec;
import net.kapitencraft.kap_lib.KapLibMod;
import net.kapitencraft.kap_lib.client.cam.modifiers.Modifier;
import net.kapitencraft.kap_lib.client.font.effect.GlyphEffect;
import net.kapitencraft.kap_lib.client.overlay.OverlayProperties;
import net.kapitencraft.kap_lib.client.particle.animation.activation_triggers.core.ActivationTrigger;
import net.kapitencraft.kap_lib.client.particle.animation.spawners.Spawner;
import net.kapitencraft.kap_lib.client.particle.animation.terminators.core.TerminationTrigger;
import net.kapitencraft.kap_lib.cooldown.Cooldown;
import net.kapitencraft.kap_lib.enchantments.abstracts.EnchantmentBlockBreakEffect;
import net.kapitencraft.kap_lib.enchantments.abstracts.EnchantmentBowEffect;
import net.kapitencraft.kap_lib.enchantments.abstracts.EnchantmentCountEffect;
import net.kapitencraft.kap_lib.inventory.page.InventoryPageType;
import net.kapitencraft.kap_lib.inventory.wearable.WearableSlot;
import net.kapitencraft.kap_lib.io.serialization.RegistrySerializer;
import net.kapitencraft.kap_lib.item.bonus.Bonus;
import net.kapitencraft.kap_lib.requirements.conditions.abstracts.ReqCondition;
import net.kapitencraft.kap_lib.client.particle.animation.elements.AnimationElement;
import net.kapitencraft.kap_lib.client.particle.animation.finalizers.ParticleFinalizer;
import net.kapitencraft.kap_lib.spawn_table.SpawnTable;
import net.kapitencraft.kap_lib.spawn_table.entries.SpawnPoolEntryType;
import net.kapitencraft.kap_lib.spawn_table.functions.core.SpawnEntityFunctionType;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.registries.RegistryBuilder;
import org.jetbrains.annotations.ApiStatus;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;

public interface ExtraRegistries {

    @ApiStatus.Internal
    List<Registry<?>> registries = new ArrayList<>();

    Registry<OverlayProperties> OVERLAY_PROPERTIES = reg(Keys.OVERLAY_PROPERTIES);
    Registry<GlyphEffect> GLYPH_EFFECTS = reg(Keys.GLYPH_EFFECTS);
    Registry<RegistrySerializer<? extends ReqCondition<?>>> REQUIREMENT_TYPES = reg(Keys.REQ_CONDITIONS);
    Registry<RegistrySerializer<? extends Bonus<?>>> BONUS_SERIALIZER = syncReg(Keys.BONUS_SERIALIZERS);

    //region enchantment
    Registry<MapCodec<? extends EnchantmentBowEffect>> ENCHANTMENT_BOW_EFFECTS = reg(Keys.ENCHANTMENT_BOW_EFFECTS);
    Registry<MapCodec<? extends EnchantmentCountEffect>> ENCHANTMENT_COUNT_EFFECTS = reg(Keys.ENCHANTMENT_COUNT_EFFECTS);
    Registry<MapCodec<? extends EnchantmentBlockBreakEffect>> ENCHANTMENT_BLOCK_BREAK_EFFECTS = reg(Keys.ENCHANTMENT_BLOCK_BREAK_EFFECTS);

    Registry<AnimationElement.Type<?>> ANIMATION_ELEMENT_TYPES = syncReg(Keys.MODIFIER_TYPES);
    Registry<Spawner.Type<?>> SPAWN_ELEMENT_TYPES = syncReg(Keys.SPAWNER_TYPES);
    Registry<ParticleFinalizer.Type<?>> PARTICLE_FINALIZER_TYPES = syncReg(Keys.FINALIZER_TYPES);
    Registry<TerminationTrigger<?>> TERMINATION_TRIGGERS = syncReg(Keys.TERMINATOR_TYPES);
    Registry<ActivationTrigger<?>> ACTIVATION_TRIGGERS = syncReg(Keys.ACTIVATION_TRIGGERS);

    Registry<Modifier.Type<?>> CAMERA_MODIFIERS = syncReg(Keys.CAMERA_MODIFIERS);

    Registry<SpawnEntityFunctionType<?>> SPAWN_FUNCTION_TYPES = reg(Keys.FUNCTION_TYPES);
    Registry<SpawnPoolEntryType> SPAWN_POOL_ENTRY_TYPES = reg(Keys.POOL_ENTRY_TYPES);

    Registry<WearableSlot> WEARABLE_SLOTS = reg(Keys.WEARABLE_SLOTS);
    Registry<InventoryPageType<?>> INVENTORY_PAGES = reg(Keys.INVENTORY_PAGES);

    Registry<Cooldown> COOLDOWNS = syncReg(Keys.COOLDOWNS);

    private static <T> Registry<T> reg(ResourceKey<Registry<T>> key) {
        Registry<T> registry = new RegistryBuilder<>(key).create();
        registries.add(registry);
        return registry;
    }

    private static <T> Registry<T> syncReg(ResourceKey<Registry<T>> key) {
        Registry<T> registry = new RegistryBuilder<>(key).sync(true).create();
        registries.add(registry);
        return registry;
    }

    @ApiStatus.Internal
    static void registerAll(Consumer<Registry<?>> register) {
        registries.forEach(register);
    }


    interface Keys {
        /**
         * default overlay properties. register inside {@link net.kapitencraft.kap_lib.event.custom.client.RegisterConfigurableOverlaysEvent#addOverlay(net.minecraft.core.Holder, Function) RegisterConfigurableOverlaysEvent#addOverlay}, to apply the overlay
         */
        ResourceKey<Registry<OverlayProperties>> OVERLAY_PROPERTIES = createRegistry("overlay_properties");
        ResourceKey<Registry<GlyphEffect>> GLYPH_EFFECTS = createRegistry("glyph_effects");
        ResourceKey<Registry<RegistrySerializer<? extends ReqCondition<?>>>> REQ_CONDITIONS = createRegistry("requirement_conditions");
        ResourceKey<Registry<RegistrySerializer<? extends Bonus<?>>>> BONUS_SERIALIZERS = createRegistry("bonus_serializers");

        ResourceKey<Registry<MapCodec<? extends EnchantmentBowEffect>>> ENCHANTMENT_BOW_EFFECTS = createRegistry("enchantment_bow_effects");
        ResourceKey<Registry<MapCodec<? extends EnchantmentCountEffect>>> ENCHANTMENT_COUNT_EFFECTS = createRegistry("enchantment_count_effects");
        ResourceKey<Registry<MapCodec<? extends EnchantmentBlockBreakEffect>>> ENCHANTMENT_BLOCK_BREAK_EFFECTS = createRegistry("enchantment_block_break_effects");

        //PARTICLE ANIMATION
        ResourceKey<Registry<AnimationElement.Type<?>>> MODIFIER_TYPES = createRegistry("particle_animation/element_types");
        ResourceKey<Registry<Spawner.Type<?>>> SPAWNER_TYPES = createRegistry("particle_animation/spawner_types");
        ResourceKey<Registry<ParticleFinalizer.Type<?>>> FINALIZER_TYPES = createRegistry("particle_animation/finalizer_types");
        ResourceKey<Registry<TerminationTrigger<?>>> TERMINATOR_TYPES = createRegistry("particle_animation/terminator_types");
        ResourceKey<Registry<ActivationTrigger<?>>> ACTIVATION_TRIGGERS = createRegistry("particle_animation/activation_triggers");

        //CAMERA CONTROL
        ResourceKey<Registry<Modifier.Type<?>>> CAMERA_MODIFIERS = createRegistry("camera_modifiers");

        //SPAWN TABLE
        ResourceKey<Registry<SpawnEntityFunctionType<?>>> FUNCTION_TYPES = createRegistry("spawn_table/function_types");
        ResourceKey<Registry<SpawnPoolEntryType>> POOL_ENTRY_TYPES = createRegistry("spawn_table/pool_entry_types");
        ResourceKey<Registry<SpawnTable>> SPAWN_TABLES = createRegistry("spawn_tables");

        ResourceKey<Registry<WearableSlot>> WEARABLE_SLOTS = createRegistry("wearable_slots");

        ResourceKey<Registry<InventoryPageType<?>>> INVENTORY_PAGES = createRegistry("inventory_pages");

        ResourceKey<Registry<Cooldown>> COOLDOWNS = createRegistry("cooldowns");

        private static <T> ResourceKey<Registry<T>> createRegistry(String id) {
            return ResourceKey.createRegistryKey(KapLibMod.res(id));
        }

        private static <T> ResourceKey<Registry<T>> vanillaRegistry(String id) {
            return ResourceKey.createRegistryKey(ResourceLocation.withDefaultNamespace(id));
        }

    }
}
