/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.commands.args;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.commands.SharedSuggestionProvider;

public abstract class SimpleEnumArg<T extends Enum<T>>
implements ArgumentType<T> {
    private final Function<T, String> mapper;
    private final T[] elements;

    protected SimpleEnumArg(Function<T, String> mapper, T[] elements) {
        this.mapper = mapper;
        this.elements = elements;
    }

    private T getElement(String in) {
        for (T element : this.elements) {
            if (!Objects.equals(in, this.mapper.apply(element))) continue;
            return element;
        }
        return null;
    }

    public T parse(StringReader reader) throws CommandSyntaxException {
        return this.getElement(reader.readString());
    }

    public Collection<String> getExamples() {
        return this.getRegNames().toList();
    }

    private Stream<String> getRegNames() {
        return Arrays.stream(this.elements).map(this.mapper);
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        return SharedSuggestionProvider.suggest(this.getRegNames(), (SuggestionsBuilder)builder);
    }
}

