/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.util;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import net.kapitencraft.kap_lib.helpers.MathHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.codec.StreamCodec;
import org.jetbrains.annotations.Range;

public record Color(float r, float g, float b, float a) {
    public static final Color RED = Color.fromARGBPacked(-65536);
    public static final Color GREEN = Color.fromARGBPacked(-16711936);
    public static final Color BLUE = Color.fromARGBPacked(-16776961);
    public static final Color BLACK_NO_ALPHA = Color.fromARGBPacked(0);
    public static final Codec<Color> CODEC = Codec.INT.xmap(Color::fromARGBPacked, Color::pack);
    public static final StreamCodec<ByteBuf, Color> STREAM_CODEC = StreamCodec.of((buffer, value) -> value.write((ByteBuf)buffer), Color::read);

    public static Color fromFormatting(ChatFormatting formatting) {
        return Color.fromARGBPacked(formatting.getColor());
    }

    public static Color fromARGBPacked(int packed) {
        return new Color((float)(packed >> 16 & 0xFF) / 255.0f, (float)(packed >> 8 & 0xFF) / 255.0f, (float)(packed & 0xFF) / 255.0f, (float)(packed >> 24 & 0xFF) / 255.0f);
    }

    public Color mul(float scale) {
        return new Color(this.r * scale, this.g * scale, this.b * scale, this.a * scale);
    }

    public Color add(Color other) {
        return new Color(this.r + other.r, this.g + other.g, this.b + other.b, this.a + other.a);
    }

    public Color setAlpha(float alpha) {
        return new Color(this.r, this.g, this.b, alpha);
    }

    public Color merge(Color other) {
        return this.add(other).mul(0.5f);
    }

    public int pack() {
        return MathHelper.ARGBtoInt((int)(this.a * 255.0f), (int)(this.r * 255.0f), (int)(this.g * 255.0f), (int)(this.b * 255.0f));
    }

    public Color mix(Color other, @Range(from=0L, to=1L) float percentage) {
        return other.mul(1.0f - percentage).add(this.mul(percentage));
    }

    public void write(ByteBuf pBuffer) {
        pBuffer.writeInt(this.pack());
    }

    public static Color read(ByteBuf buf) {
        return Color.fromARGBPacked(buf.readInt());
    }

    public TextColor toTextColor() {
        return TextColor.fromRgb((int)this.pack());
    }
}

