/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.cooldown;

import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import net.kapitencraft.kap_lib.cooldown.Cooldown;
import net.kapitencraft.kap_lib.io.network.S2C.capability.CooldownStartedPacket;
import net.kapitencraft.kap_lib.io.network.S2C.capability.SyncCooldownsToPlayerPacket;
import net.kapitencraft.kap_lib.registry.ModAttachmentTypes;
import net.kapitencraft.kap_lib.util.IntegerReference;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Internal
public class Cooldowns {
    public static final Codec<Cooldowns> CODEC = Codec.unboundedMap(Cooldown.CODEC, IntegerReference.CODEC).xmap(Cooldowns::new, c -> c.active);
    private final Map<Cooldown, IntegerReference> active = new HashMap<Cooldown, IntegerReference>();

    private Cooldowns(Map<Cooldown, IntegerReference> active) {
        this.active.putAll(active);
    }

    public Cooldowns() {
    }

    public boolean isActive(Cooldown cooldown) {
        return this.active.containsKey(cooldown);
    }

    public void tick(LivingEntity entity) {
        ArrayList toRemove = new ArrayList();
        this.active.forEach((cooldown, integerReference) -> {
            integerReference.decrease();
            if (integerReference.getIntValue() <= 0) {
                toRemove.add(cooldown);
            }
        });
        toRemove.forEach(c -> {
            c.onDone(entity);
            this.active.remove(c);
        });
    }

    public void applyCooldown(LivingEntity entity, Cooldown cooldown, boolean reduceWithTime) {
        int time = cooldown.getCooldownTime(entity, reduceWithTime);
        if (time > 0) {
            this.active.put(cooldown, IntegerReference.create(time));
            PacketDistributor.sendToAllPlayers((CustomPacketPayload)new CooldownStartedPacket(cooldown, time, entity.getId()), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public int getCooldownTime(Cooldown cooldown) {
        IntegerReference reference = this.active.get(cooldown);
        return reference == null ? 0 : reference.getIntValue();
    }

    public Map<Cooldown, Integer> getData() {
        HashMap<Cooldown, Integer> map = new HashMap<Cooldown, Integer>();
        this.active.forEach((cooldown, integerReference) -> map.put((Cooldown)cooldown, integerReference.getIntValue()));
        return map;
    }

    public void loadData(Map<Cooldown, Integer> map) {
        map.forEach((cooldown, integer) -> this.active.put((Cooldown)cooldown, IntegerReference.create(integer)));
    }

    public static Cooldowns get(LivingEntity living) {
        return Objects.requireNonNull((Cooldowns)living.getData(ModAttachmentTypes.COOLDOWNS), "unable to get cooldowns");
    }

    public static void send(ServerPlayer sP) {
        Cooldowns cooldown = Cooldowns.get((LivingEntity)sP);
        PacketDistributor.sendToPlayer((ServerPlayer)sP, (CustomPacketPayload)new SyncCooldownsToPlayerPacket(sP.getId(), cooldown.getData()), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public void setCooldownTime(Cooldown cooldown, int duration) {
        this.active.put(cooldown, IntegerReference.create(duration));
    }
}

