/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.spawn_table.entries;

import com.google.common.collect.Lists;
import com.mojang.serialization.MapCodec;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import net.kapitencraft.kap_lib.registry.custom.spawn_table.SpawnPoolEntries;
import net.kapitencraft.kap_lib.spawn_table.entries.ComposableEntryContainer;
import net.kapitencraft.kap_lib.spawn_table.entries.CompositeEntryBase;
import net.kapitencraft.kap_lib.spawn_table.entries.SpawnPoolEntryContainer;
import net.kapitencraft.kap_lib.spawn_table.entries.SpawnPoolEntryType;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class AlternativesEntry
extends CompositeEntryBase {
    public static final MapCodec<AlternativesEntry> CODEC = AlternativesEntry.createCodec(AlternativesEntry::new);

    public AlternativesEntry(List<SpawnPoolEntryContainer> pChildren, List<LootItemCondition> pConditions) {
        super(pChildren, pConditions);
    }

    @Override
    public SpawnPoolEntryType getType() {
        return SpawnPoolEntries.ALTERNATIVES.get();
    }

    @Override
    protected ComposableEntryContainer compose(List<? extends ComposableEntryContainer> pEntries) {
        return switch (pEntries.size()) {
            case 0 -> ComposableEntryContainer.ALWAYS_FALSE;
            case 1 -> pEntries.get(0);
            case 2 -> pEntries.get(0).or(pEntries.get(1));
            default -> (p_79393_, p_79394_) -> {
                for (ComposableEntryContainer composableentrycontainer : pEntries) {
                    if (!composableentrycontainer.expand(p_79393_, p_79394_)) continue;
                    return true;
                }
                return false;
            };
        };
    }

    @Override
    public void validate(ValidationContext pValidationContext) {
        super.validate(pValidationContext);
        for (int i = 0; i < this.children.size() - 1; ++i) {
            if (!((SpawnPoolEntryContainer)this.children.get((int)i)).conditions.isEmpty()) continue;
            pValidationContext.reportProblem("Unreachable entry!");
        }
    }

    public static Builder alternatives(SpawnPoolEntryContainer.Builder<?> ... pChildren) {
        return new Builder(pChildren);
    }

    public static <E> Builder alternatives(Collection<E> pChildrenSources, Function<E, SpawnPoolEntryContainer.Builder<?>> pToChildrenFunction) {
        return new Builder((SpawnPoolEntryContainer.Builder[])pChildrenSources.stream().map(pToChildrenFunction::apply).toArray(SpawnPoolEntryContainer.Builder[]::new));
    }

    public static class Builder
    extends SpawnPoolEntryContainer.Builder<Builder> {
        private final List<SpawnPoolEntryContainer> entries = Lists.newArrayList();

        public Builder(SpawnPoolEntryContainer.Builder<?> ... pChildren) {
            for (SpawnPoolEntryContainer.Builder<?> builder : pChildren) {
                this.entries.add(builder.build());
            }
        }

        @Override
        protected Builder getThis() {
            return this;
        }

        @Override
        public Builder otherwise(SpawnPoolEntryContainer.Builder<?> pChildBuilder) {
            this.entries.add(pChildBuilder.build());
            return this;
        }

        @Override
        public SpawnPoolEntryContainer build() {
            return new AlternativesEntry(this.entries, this.getConditions());
        }
    }
}

