/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.spawn_table.entries;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.Consumer;
import net.kapitencraft.kap_lib.registry.custom.spawn_table.SpawnPoolEntries;
import net.kapitencraft.kap_lib.spawn_table.SpawnContext;
import net.kapitencraft.kap_lib.spawn_table.SpawnPoolEntry;
import net.kapitencraft.kap_lib.spawn_table.entries.ComposableEntryContainer;
import net.kapitencraft.kap_lib.spawn_table.entries.SpawnPoolEntryContainer;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public abstract class CompositeEntryBase
extends SpawnPoolEntryContainer {
    protected final List<SpawnPoolEntryContainer> children;
    private final ComposableEntryContainer composedChildren;

    protected CompositeEntryBase(List<SpawnPoolEntryContainer> pChildren, List<LootItemCondition> pConditions) {
        super(pConditions);
        this.children = pChildren;
        this.composedChildren = this.compose(pChildren);
    }

    @Override
    public void validate(ValidationContext pValidationContext) {
        super.validate(pValidationContext);
        if (this.children.isEmpty()) {
            pValidationContext.reportProblem("Empty children list");
        }
        for (int i = 0; i < this.children.size(); ++i) {
            this.children.get(i).validate(pValidationContext.forChild(".entry[" + i + "]"));
        }
    }

    protected abstract ComposableEntryContainer compose(List<? extends ComposableEntryContainer> var1);

    @Override
    public final boolean expand(SpawnContext pLootContext, Consumer<SpawnPoolEntry> pEntryConsumer) {
        return this.canRun(pLootContext) && this.composedChildren.expand(pLootContext, pEntryConsumer);
    }

    public static <T extends CompositeEntryBase> MapCodec<T> createCodec(CompositeEntryConstructor<T> factory) {
        return RecordCodecBuilder.mapCodec(p_338125_ -> p_338125_.group((App)SpawnPoolEntries.CODEC.listOf().optionalFieldOf("children", List.of()).forGetter(p_299120_ -> p_299120_.children)).and(CompositeEntryBase.commonFields(p_338125_).t1()).apply((Applicative)p_338125_, factory::create));
    }

    @FunctionalInterface
    public static interface CompositeEntryConstructor<T extends CompositeEntryBase> {
        public T create(List<SpawnPoolEntryContainer> var1, List<LootItemCondition> var2);
    }
}

