/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.spawn_table.entries;

import com.google.common.collect.Lists;
import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import net.kapitencraft.kap_lib.registry.custom.spawn_table.SpawnEntityFunctions;
import net.kapitencraft.kap_lib.spawn_table.SpawnContext;
import net.kapitencraft.kap_lib.spawn_table.SpawnPoolEntry;
import net.kapitencraft.kap_lib.spawn_table.entries.SpawnPoolEntryContainer;
import net.kapitencraft.kap_lib.spawn_table.functions.core.FunctionUserBuilder;
import net.kapitencraft.kap_lib.spawn_table.functions.core.SpawnEntityFunction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public abstract class SpawnPoolSingletonContainer
extends SpawnPoolEntryContainer {
    public static final int DEFAULT_WEIGHT = 1;
    public static final int DEFAULT_QUALITY = 0;
    protected final int weight;
    protected final int quality;
    protected final List<SpawnEntityFunction> functions;
    final BiFunction<Entity, SpawnContext, Entity> compositeFunction;
    private final SpawnPoolEntry entry = new EntryBase(){

        @Override
        public void createEntity(Consumer<Entity> entitySink, SpawnContext context) {
            SpawnPoolSingletonContainer.this.createEntity(SpawnEntityFunction.decorate(SpawnPoolSingletonContainer.this.compositeFunction, entitySink, context), context);
        }
    };

    protected SpawnPoolSingletonContainer(int pWeight, int pQuality, List<LootItemCondition> pConditions, List<SpawnEntityFunction> pFunctions) {
        super(pConditions);
        this.weight = pWeight;
        this.quality = pQuality;
        this.functions = pFunctions;
        this.compositeFunction = SpawnEntityFunctions.compose(pFunctions);
    }

    @Override
    public void validate(ValidationContext pValidationContext) {
        super.validate(pValidationContext);
        for (int i = 0; i < this.functions.size(); ++i) {
            this.functions.get(i).validate(pValidationContext.forChild(".functions[" + i + "]"));
        }
    }

    protected abstract void createEntity(Consumer<Entity> var1, SpawnContext var2);

    @Override
    public boolean expand(SpawnContext pLootContext, Consumer<SpawnPoolEntry> pEntryConsumer) {
        if (this.canRun(pLootContext)) {
            pEntryConsumer.accept(this.entry);
            return true;
        }
        return false;
    }

    public static Builder<?> simpleBuilder(EntryConstructor pEntryBuilder) {
        return new DummyBuilder(pEntryBuilder);
    }

    protected static <T extends SpawnPoolSingletonContainer> Products.P4<RecordCodecBuilder.Mu<T>, Integer, Integer, List<LootItemCondition>, List<SpawnEntityFunction>> singletonFields(RecordCodecBuilder.Instance<T> instance) {
        return instance.group((App)Codec.INT.optionalFieldOf("weight", (Object)1).forGetter(p_299262_ -> p_299262_.weight), (App)Codec.INT.optionalFieldOf("quality", (Object)0).forGetter(p_299272_ -> p_299272_.quality)).and(SpawnPoolSingletonContainer.commonFields(instance).t1()).and((App)SpawnEntityFunctions.ROOT_CODEC.listOf().optionalFieldOf("functions", List.of()).forGetter(p_298225_ -> p_298225_.functions));
    }

    static class DummyBuilder
    extends Builder<DummyBuilder> {
        private final EntryConstructor constructor;

        public DummyBuilder(EntryConstructor pConstructor) {
            this.constructor = pConstructor;
        }

        @Override
        protected DummyBuilder getThis() {
            return this;
        }

        @Override
        public SpawnPoolEntryContainer build() {
            return this.constructor.build(this.weight, this.quality, this.getConditions(), this.getFunctions());
        }
    }

    @FunctionalInterface
    protected static interface EntryConstructor {
        public SpawnPoolSingletonContainer build(int var1, int var2, List<LootItemCondition> var3, List<SpawnEntityFunction> var4);
    }

    protected abstract class EntryBase
    implements SpawnPoolEntry {
        protected EntryBase() {
        }

        @Override
        public int getWeight(float pLuck) {
            return Math.max(Mth.floor((float)((float)SpawnPoolSingletonContainer.this.weight + (float)SpawnPoolSingletonContainer.this.quality * pLuck)), 0);
        }
    }

    public static abstract class Builder<T extends Builder<T>>
    extends SpawnPoolEntryContainer.Builder<T>
    implements FunctionUserBuilder<T> {
        protected int weight = 1;
        protected int quality = 0;
        private final List<SpawnEntityFunction> functions = Lists.newArrayList();

        @Override
        public T apply(SpawnEntityFunction.Builder pFunctionBuilder) {
            this.functions.add(pFunctionBuilder.build());
            return (T)((Builder)this.getThis());
        }

        protected List<SpawnEntityFunction> getFunctions() {
            return this.functions;
        }

        public T setWeight(int pWeight) {
            this.weight = pWeight;
            return (T)((Builder)this.getThis());
        }

        public T setQuality(int pQuality) {
            this.quality = pQuality;
            return (T)((Builder)this.getThis());
        }
    }
}

