/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.util;

import java.util.List;
import net.kapitencraft.kap_lib.config.ClientModConfig;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.Slot;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ContainerScreenEvent;
import net.neoforged.neoforge.client.event.RenderTooltipEvent;
import net.neoforged.neoforge.client.event.ScreenEvent;
import org.jetbrains.annotations.ApiStatus;
import org.joml.Vector2i;

@EventBusSubscriber(value={Dist.CLIENT})
@ApiStatus.Internal
public class ScrollableTooltips {
    private static int scrollY = 0;
    private static int initY = 0;
    private static float scale = 1.0f;
    private static boolean allowScroll;
    private static int oldTooltipSize;
    private static Slot active;

    @SubscribeEvent
    public static void onRenderForeground(ContainerScreenEvent.Render.Foreground event) {
        AbstractContainerScreen screen = event.getContainerScreen();
        if (screen.hoveredSlot != active) {
            scrollY = 0;
            active = screen.hoveredSlot;
        }
    }

    @SubscribeEvent
    public static void registerScrollable(RenderTooltipEvent.Pre event) {
        int i;
        Vector2i toolTipSize = ScrollableTooltips.createToolTipBoxSize(event.getComponents(), event.getFont());
        Vector2i screenSize = new Vector2i(event.getScreenWidth(), event.getScreenHeight());
        Vector2i pos = new Vector2i(event.getX(), event.getY());
        int height = event.getY();
        allowScroll = toolTipSize.y > screenSize.y;
        boolean isHigherThanScreen = allowScroll;
        if (!(scrollY != 0 && isHigherThanScreen || pos.y + (i = toolTipSize.y + 3) <= screenSize.y)) {
            height = screenSize.y - i;
        }
        if (isHigherThanScreen) {
            if (oldTooltipSize != toolTipSize.y && oldTooltipSize != 0) {
                scrollY *= (int)((double)toolTipSize.y / (double)oldTooltipSize);
                oldTooltipSize = toolTipSize.y;
            }
            if (scrollY == 0) {
                initY = height;
            }
            event.setY(initY + scrollY);
            return;
        }
        event.setY(height);
    }

    @SubscribeEvent
    public static void scrollEvent(ScreenEvent.MouseScrolled.Pre event) {
        if (active != null && active.hasItem() && allowScroll) {
            event.setCanceled(true);
            float scrollDelta = (float)event.getScrollDeltaY();
            int scrollOffset = Mth.floor((double)((double)scrollDelta * ClientModConfig.getScrollScale()));
            if (Screen.hasControlDown()) {
                scale += (float)scrollOffset;
            } else {
                scrollY -= scrollOffset;
            }
        }
    }

    private static Vector2i createToolTipBoxSize(List<ClientTooltipComponent> components, Font font) {
        int i = 0;
        int j = 0;
        for (ClientTooltipComponent clienttooltipcomponent : components) {
            int k = clienttooltipcomponent.getWidth(font);
            if (k > i) {
                i = k;
            }
            j += clienttooltipcomponent.getHeight();
        }
        return new Vector2i(i, j);
    }

    static {
        oldTooltipSize = 0;
    }
}

