/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.client.particle.animation;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.Codec;
import net.kapitencraft.kap_lib.client.particle.animation.ParticleAnimationInfo;
import net.kapitencraft.kap_lib.client.particle.animation.ParticleAnimationParameters;
import net.kapitencraft.kap_lib.registry.ModParticleTypes;
import net.minecraft.core.IdMap;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParticleAnimationOptions
extends ParticleType<ParticleAnimationOptions>
implements ParticleOptions {
    final ParticleOptions options;
    final ParticleAnimationParameters params;
    final ParticleAnimationInfo info;
    final int amount;

    public ParticleAnimationOptions(ParticleOptions options, ParticleAnimationParameters context, ParticleAnimationInfo info, int amount) {
        super(true, (ParticleOptions.Deserializer)new Deserializer());
        this.options = options;
        this.params = context;
        this.info = info;
        this.amount = amount;
    }

    @NotNull
    public ParticleType<?> m_6012_() {
        return (ParticleType)ModParticleTypes.ANIMATION.get();
    }

    public void m_7711_(@NotNull FriendlyByteBuf buf) {
        this.options.m_7711_(buf);
        this.params.writeToNetwork(buf);
        this.info.writeToNetwork(buf);
        buf.writeInt(this.amount);
    }

    @NotNull
    public String m_5942_() {
        return this.options.m_5942_();
    }

    @NotNull
    public Codec<ParticleAnimationOptions> m_7652_() {
        return Codec.unit((Object)((Object)this));
    }

    private static <T extends ParticleOptions> T readParticle(FriendlyByteBuf p_132305_, @Nullable ParticleType<T> p_132306_) {
        return (T)(p_132306_ == null ? null : p_132306_.m_123743_().m_6507_(p_132306_, p_132305_));
    }

    public static class Deserializer
    implements ParticleOptions.Deserializer<ParticleAnimationOptions> {
        @NotNull
        public ParticleAnimationOptions fromCommand(@NotNull ParticleType<ParticleAnimationOptions> p_123733_, @NotNull StringReader p_123734_) throws CommandSyntaxException {
            throw new IllegalAccessError("tried accessing animator via command");
        }

        @NotNull
        public ParticleAnimationOptions fromNetwork(@NotNull ParticleType<ParticleAnimationOptions> type, FriendlyByteBuf buf) {
            ParticleType type1 = (ParticleType)buf.m_236816_((IdMap)BuiltInRegistries.f_257034_);
            Object options = ParticleAnimationOptions.readParticle(buf, type1);
            ParticleAnimationParameters context = ParticleAnimationParameters.loadFromNetwork(buf);
            ParticleAnimationInfo info = ParticleAnimationInfo.loadFromNetwork(buf);
            return new ParticleAnimationOptions((ParticleOptions)options, context, info, buf.readInt());
        }
    }
}

