/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.collection;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.kapitencraft.kap_lib.collection.StreamEntry;

public class MapStream<T, K> {
    private final Map<T, K> map = new HashMap<T, K>();

    public static <T, K> MapStream<T, K> of(Map<T, K> map) {
        MapStream<T, K> stream = new MapStream<T, K>();
        stream.map.putAll(map);
        return stream;
    }

    public static <T, K> MapStream<T, K> create() {
        return new MapStream<T, K>();
    }

    public static <T, K> MapStream<T, K> create(List<T> keys, List<K> values) {
        if (keys.size() != values.size()) {
            throw new IllegalStateException("tried creating map from different length collections");
        }
        ArrayList<StreamEntry<T, K>> entries = new ArrayList<StreamEntry<T, K>>();
        for (int i = 0; i < keys.size(); ++i) {
            entries.add(new StreamEntry<T, K>(keys.get(i), values.get(i)));
        }
        return MapStream.of(entries);
    }

    public <J> Stream<J> mapToSimple(BiFunction<T, K, J> mapper) {
        ArrayList list = new ArrayList();
        this.map.forEach((? super K t, ? super V k) -> list.add(mapper.apply(t, k)));
        return list.stream();
    }

    public MapStream<T, K> filter(BiPredicate<T, K> predicate) {
        HashMap map = new HashMap();
        this.map.forEach((? super K t, ? super V k) -> {
            if (predicate.test(t, k)) {
                map.put(t, k);
            }
        });
        return MapStream.of(map);
    }

    public MapStream<T, K> filterKeys(Predicate<T> keyFilter) {
        return this.filterKeys(keyFilter, null);
    }

    public MapStream<T, K> filterKeys(Predicate<T> keyFilter, @Nullable BiConsumer<T, K> forFailed) {
        HashMap map = new HashMap();
        this.map.forEach((? super K t, ? super V k) -> {
            if (keyFilter.test(t)) {
                map.put(t, k);
            } else if (forFailed != null) {
                forFailed.accept(t, k);
            }
        });
        return MapStream.of(map);
    }

    public MapStream<T, K> filterValues(Predicate<K> keyFilter, @Nullable BiConsumer<T, K> forFailed) {
        HashMap map = new HashMap();
        this.map.forEach((? super K t, ? super V k) -> {
            if (keyFilter.test(k)) {
                map.put(t, k);
            } else if (forFailed != null) {
                forFailed.accept(t, k);
            }
        });
        return MapStream.of(map);
    }

    public <J> MapStream<T, J> mapValues(Function<K, J> mapper) {
        List keys = this.map.keySet().stream().toList();
        List<J> values = this.map.values().stream().map(mapper).toList();
        return MapStream.create(keys, values);
    }

    public <J> MapStream<J, K> mapKeys(Function<T, J> mapper) {
        List<J> keys = this.map.keySet().stream().map(mapper).toList();
        List<K> values = this.map.values().stream().toList();
        return MapStream.create(keys, values);
    }

    public MapStream<T, K> filterNulls() {
        return this.filter((t, k) -> t != null && k != null);
    }

    public Map<T, K> toMap() {
        return Map.copyOf(this.map);
    }

    public <J, I> MapStream<J, I> biMap(BiFunction<T, K, StreamEntry<J, I>> mapper) {
        return MapStream.of(this.mapToSimple(mapper).toList());
    }

    public MapStream<T, K> forEach(BiConsumer<T, K> consumer) {
        this.map.forEach(consumer);
        return this;
    }

    private static <T, K> MapStream<T, K> of(List<StreamEntry<T, K>> list) {
        HashMap map = new HashMap();
        list.forEach((? super T entry) -> map.put(entry.t(), entry.k()));
        return MapStream.of(map);
    }

    public boolean allMatch(BiPredicate<T, K> predicate) {
        int i = this.map.size();
        MapStream<T, K> filtered = this.filter(predicate);
        return i == filtered.map.size();
    }

    public boolean anyMatch(BiPredicate<T, K> predicate) {
        return !this.filter(predicate).map.isEmpty();
    }

    public boolean noneMatch(BiPredicate<T, K> predicate) {
        return this.filter(predicate).map.isEmpty();
    }
}

