/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.mixin.classes;

import net.kapitencraft.kap_lib.entity.fishing.IFishingHook;
import net.kapitencraft.kap_lib.entity.fishing.ModFishingHook;
import net.kapitencraft.kap_lib.entity.item.NoFireItemEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.projectile.FishingHook;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={FishingHook.class})
public abstract class FishingHookMixin
extends Projectile
implements IFishingHook {
    @Shadow
    public int f_37097_;
    private int hookSpeedModifier = 0;
    @Shadow
    private int f_37090_;

    private FishingHook self() {
        return (FishingHook)this;
    }

    @Override
    public int getHookSpeedModifier() {
        return this.hookSpeedModifier;
    }

    @Override
    public void setHookSpeedModifier(int hookSpeedModifier) {
        this.hookSpeedModifier = hookSpeedModifier;
    }

    protected FishingHookMixin(EntityType<? extends Projectile> p_37248_, Level p_37249_) {
        super(p_37248_, p_37249_);
    }

    @ModifyArg(method={"retrieve"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/storage/loot/LootDataManager;getLootTable(Lnet/minecraft/resources/ResourceLocation;)Lnet/minecraft/world/level/storage/loot/LootTable;"))
    public ResourceLocation modifyLocation(ResourceLocation id) {
        return this.lootTableId();
    }

    @Redirect(method={"retrieve"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;addFreshEntity(Lnet/minecraft/world/entity/Entity;)Z", ordinal=0))
    public boolean add(Level instance, Entity entity) {
        if (this.self() instanceof ModFishingHook) {
            ItemEntity item = (ItemEntity)entity;
            return instance.m_7967_((Entity)NoFireItemEntity.copy(item));
        }
        return instance.m_7967_(entity);
    }

    @ModifyArg(method={"tick", "getOpenWaterTypeForBlock"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/material/FluidState;is(Lnet/minecraft/tags/TagKey;)Z"))
    public TagKey<Fluid> isProxy(TagKey<Fluid> key) {
        return this.getFluidType();
    }

    @Redirect(method={"catchingFish"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/block/state/BlockState;is(Lnet/minecraft/world/level/block/Block;)Z"))
    public boolean changeMaterial(BlockState instance, Block block) {
        return instance.m_60713_(this.getBlock());
    }

    @Inject(method={"catchingFish"}, at={@At(value="INVOKE", target="Lnet/minecraft/util/Mth;nextInt(Lnet/minecraft/util/RandomSource;II)I", ordinal=2)}, cancellable=true)
    public void catchingFish(BlockPos p_37146_, CallbackInfo ci) {
        this.f_37090_ = Mth.m_216271_((RandomSource)this.f_19796_, (int)100, (int)600);
        this.f_37090_ -= this.f_37097_ * 100;
        this.f_37090_ = Math.max(1, this.f_37090_);
        ci.cancel();
    }

    @Redirect(method={"catchingFish"}, at=@At(value="INVOKE", target="Lnet/minecraft/util/Mth;nextInt(Lnet/minecraft/util/RandomSource;II)I", ordinal=1))
    public int getRandom(RandomSource source, int low, int high) {
        return Mth.m_216271_((RandomSource)source, (int)Math.max(1, low - this.getHookSpeedModifier() * 5), (int)Math.max(1, high - this.getHookSpeedModifier() * 15));
    }

    @Redirect(method={"catchingFish"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/level/ServerLevel;sendParticles(Lnet/minecraft/core/particles/ParticleOptions;DDDIDDDD)I"))
    public int sendParticles(ServerLevel level, ParticleOptions options, double d, double d1, double d2, int i1, double d3, double d4, double d5, double d6) {
        if (options == ParticleTypes.f_123769_) {
            options = this.getSplashParticle();
        } else if (options == ParticleTypes.f_123816_) {
            options = this.getFishingParticle();
        } else if (options == ParticleTypes.f_123795_) {
            options = this.getBubbleParticle();
        }
        return level.m_8767_(options, d, d1, d2, i1, d3, d4, d5, d6);
    }
}

