/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.client.cam.core;

import net.kapitencraft.kap_lib.client.cam.core.CameraData;
import net.kapitencraft.kap_lib.client.cam.core.TrackingShot;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.ViewportEvent;
import net.neoforged.neoforge.common.NeoForge;

@OnlyIn(value=Dist.CLIENT)
public class CameraController {
    private final Camera camera;
    private boolean running;
    private boolean wasHiding;
    private TrackingShot shot;
    public final CameraData data;
    private boolean shaking;
    private float oShake;
    private float shake;
    private float shakeVal;
    private float shakeIntensity;
    private float shakeFrequency;
    private int shakeTime;

    public CameraController() {
        this.camera = Minecraft.getInstance().gameRenderer.getMainCamera();
        this.running = false;
        this.wasHiding = false;
        this.shaking = false;
        this.shakeTime = 0;
        this.data = new CameraData();
        NeoForge.EVENT_BUS.register((Object)this);
    }

    public void activate(TrackingShot shot) {
        this.running = true;
        this.shot = shot;
        shot.setup();
        Vec3 pos = this.camera.getPosition();
        Vec2 rot = new Vec2(this.camera.getXRot(), this.camera.getYRot());
        this.data.update(pos, rot);
        Options options = Minecraft.getInstance().options;
        this.wasHiding = options.hideGui;
        options.hideGui = true;
    }

    public void shake(float intensity, float strength, float frequency) {
        this.shaking = true;
        this.shakeIntensity = intensity;
        this.shakeVal = strength;
        this.shakeFrequency = frequency;
    }

    @SubscribeEvent
    public void tick(ClientTickEvent.Pre event) {
        if (this.running) {
            if (this.shot.done()) {
                this.disable();
            } else {
                this.data.tick();
                this.shot.tick(this.data);
            }
        }
        if (this.shaking) {
            this.oShake = this.shake;
            this.shake = Mth.sin((float)((float)this.shakeTime++ * this.shakeFrequency)) * this.shakeVal;
            this.shakeVal -= this.shakeIntensity;
            if (this.shakeVal <= 0.0f) {
                this.shaking = false;
            }
        }
    }

    private void disable() {
        this.running = false;
        Minecraft.getInstance().options.hideGui = this.wasHiding;
    }

    @SubscribeEvent
    public void onViewportComputeCameraAngles(ViewportEvent.ComputeCameraAngles event) {
        double partialTick = event.getPartialTick();
        if (this.running) {
            Vec3 rot = this.data.getRot(partialTick);
            event.setPitch((float)rot.x);
            event.setYaw((float)rot.y);
            event.setRoll((float)rot.z);
            event.getCamera().setPosition(this.data.getPos(partialTick));
        }
        if (!(!this.shaking || this.running && this.shot.suppressesShake())) {
            Vec3 pos = event.getCamera().getPosition();
            event.getCamera().setPosition(pos.add(0.0, (double)Mth.lerp((float)((float)partialTick), (float)this.oShake, (float)this.shake), 0.0));
        }
    }

    public boolean running() {
        return this.running;
    }
}

