/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.client.cam.core;

import net.kapitencraft.kap_lib.helpers.MathHelper;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;

public class CameraData {
    public Vec3 pos;
    public Vec3 rot;
    private Vec3 oPos;
    private Vec3 oRot;
    public Entity target;
    public boolean detached;
    public boolean thirdPerson;

    public void update(Vec3 pos, Vec2 rot) {
        this.pos = pos;
        this.rot = MathHelper.withRoll(rot, 0.0f);
        this.tick();
        Minecraft minecraft = Minecraft.getInstance();
        this.target = minecraft.getCameraEntity() == null ? minecraft.player : minecraft.getCameraEntity();
        CameraType cameraType = minecraft.options.getCameraType();
        this.detached = !cameraType.isFirstPerson();
        this.thirdPerson = !cameraType.isMirrored();
    }

    public void tick() {
        this.oPos = this.pos;
        this.oRot = this.rot;
    }

    public Vec3 getPos(double partialTick) {
        return this.oPos.lerp(this.pos, partialTick);
    }

    public Vec3 getRot(double partialTick) {
        return this.oRot.lerp(this.rot, partialTick);
    }
}

