/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.client.gui.screen;

import java.util.List;
import net.kapitencraft.kap_lib.client.gui.IMenuBuilder;
import net.kapitencraft.kap_lib.client.widget.menu.Menu;
import net.kapitencraft.kap_lib.helpers.MiscHelper;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MenuableScreen
extends Screen {
    private Menu active;
    private IMenuBuilder defaultMenuBuilder;

    protected MenuableScreen(Component pTitle) {
        super(pTitle);
    }

    protected void setDefaultMenuBuilder(IMenuBuilder defaultMenuBuilder) {
        this.defaultMenuBuilder = defaultMenuBuilder;
    }

    public void render(@NotNull GuiGraphics pPoseStack, int pMouseX, int pMouseY, float pPartialTick) {
        super.render(pPoseStack, pMouseX, pMouseY, pPartialTick);
        MiscHelper.ifNonNull(this.active, menu -> menu.render(pPoseStack, pMouseX, pMouseY, pPartialTick));
    }

    public void mouseMoved(double pMouseX, double pMouseY) {
        MiscHelper.ifNonNull(this.active, menu -> menu.mouseMoved(pMouseX, pMouseY));
    }

    public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
        GuiEventListener listener = null;
        if (this.getFocused() instanceof Menu && this.getFocused().mouseClicked(pMouseX, pMouseY, pButton)) {
            listener = this.getFocused();
        } else {
            for (GuiEventListener eventListener : List.copyOf(this.children())) {
                if (!eventListener.mouseClicked(pMouseX, pMouseY, pButton)) continue;
                if (eventListener instanceof IMenuBuilder) {
                    IMenuBuilder builder = (IMenuBuilder)eventListener;
                    if (pButton == 1) {
                        listener = this.makeMenu(builder, pMouseX, pMouseY);
                        continue;
                    }
                }
                listener = eventListener;
            }
        }
        if (pButton == 1 && listener == null && this.defaultMenuBuilder != null) {
            listener = this.makeMenu(this.defaultMenuBuilder, pMouseX, pMouseY);
        }
        if (listener != null) {
            this.setFocused(listener);
            if (pButton == 0) {
                this.setDragging(true);
            }
            return true;
        }
        if (this.active != null) {
            this.closeMenu();
            return true;
        }
        return false;
    }

    private GuiEventListener makeMenu(IMenuBuilder builder, double pMouseX, double pMouseY) {
        Menu menu = builder.createMenu(Mth.floor((double)pMouseX), Mth.floor((double)pMouseY), this);
        if (menu != null) {
            this.active = menu;
            this.active.show();
            return this.active;
        }
        return null;
    }

    public void closeMenu() {
        this.active.hide(this);
        this.active = null;
    }

    public boolean keyPressed(int pKeyCode, int pScanCode, int pModifiers) {
        if (pKeyCode == 256 && this.active != null) {
            this.closeMenu();
            return true;
        }
        return super.keyPressed(pKeyCode, pScanCode, pModifiers);
    }

    public void setFocused(@Nullable GuiEventListener pListener) {
        super.setFocused(pListener == this ? null : pListener);
    }
}

