/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.data_gen.abst;

import java.util.function.Supplier;
import net.kapitencraft.kap_lib.helpers.CollectionHelper;
import net.kapitencraft.kap_lib.helpers.TextHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.enchantment.Enchantment;
import net.neoforged.neoforge.common.data.LanguageProvider;
import org.jetbrains.annotations.Nullable;

public abstract class EnglishLanguageProvider
extends LanguageProvider {
    private final String modId;

    public EnglishLanguageProvider(PackOutput output, String modId) {
        super(output, modId, "en_us");
        this.modId = modId;
    }

    public void addDeathMessage(String msgId, String msg) {
        this.add("death.attack." + msgId, msg);
        this.add("death.attack." + msgId + ".item", msg + " using %3$s");
    }

    public void addItem(Supplier<Item> item) {
        this.addItem(item, TextHelper.makeGrammar(BuiltInRegistries.ITEM.getKey((Object)item.get()).getPath()));
    }

    public void bonusWithTranslation(boolean set, String key, String name, String ... description) {
        String translationKey = (set ? "set." : "") + "bonus." + this.modId + "." + key;
        this.add(translationKey, name);
        this.translation(translationKey, description);
    }

    public void addEnchantmentWithDescription(Holder<Enchantment> enchantment, String ... description) {
        ResourceLocation location = enchantment.getKey().location();
        String id = Util.makeDescriptionId((String)"enchantment", (ResourceLocation)location);
        this.add(id, TextHelper.makeGrammar(location.getPath()));
        this.translation(id, description);
    }

    public void addAttribute(Holder<Attribute> attribute, @Nullable ChatFormatting color) {
        String id = attribute.getKey().location().getPath();
        String name = (String)(color != null ? "\u00a7" + color.getChar() : "") + TextHelper.makeGrammar(CollectionHelper.getLast(id.split("\\.")));
        this.add(id, name);
        String descriptionId = ((Attribute)attribute.value()).getDescriptionId();
        if (!id.equals(descriptionId)) {
            this.add(descriptionId, name);
        }
    }

    protected void translation(String baseName, String ... description) {
        baseName = (String)baseName + ".desc";
        for (int i = 0; i < description.length; ++i) {
            this.add((String)baseName + (String)(i == 0 ? "" : "." + i), description[i]);
        }
    }
}

