/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.helpers;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.mojang.datafixers.util.Function10;
import com.mojang.datafixers.util.Function7;
import com.mojang.datafixers.util.Function8;
import com.mojang.datafixers.util.Function9;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import net.kapitencraft.kap_lib.collection.DoubleMap;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class ExtraStreamCodecs {
    public static final StreamCodec<? super FriendlyByteBuf, Vec3> VEC_3 = StreamCodec.of(FriendlyByteBuf::writeVec3, FriendlyByteBuf::readVec3);
    public static final StreamCodec<? super ByteBuf, EquipmentSlot> EQUIPMENT_SLOT = ByteBufCodecs.STRING_UTF8.map(EquipmentSlot::byName, EquipmentSlot::getName);
    public static final StreamCodec<ByteBuf, UUID> UUID = ByteBufCodecs.STRING_UTF8.map(UUID::fromString, UUID::toString);

    public static <B, C, T1, T2, T3, T4, T5, T6, T7> StreamCodec<B, C> composite(final StreamCodec<? super B, T1> codec1, final Function<C, T1> getter1, final StreamCodec<? super B, T2> codec2, final Function<C, T2> getter2, final StreamCodec<? super B, T3> codec3, final Function<C, T3> getter3, final StreamCodec<? super B, T4> codec4, final Function<C, T4> getter4, final StreamCodec<? super B, T5> codec5, final Function<C, T5> getter5, final StreamCodec<? super B, T6> codec6, final Function<C, T6> getter6, final StreamCodec<? super B, T7> codec7, final Function<C, T7> getter7, final Function7<T1, T2, T3, T4, T5, T6, T7, C> factory) {
        return new StreamCodec<B, C>(){

            @NotNull
            public C decode(@NotNull B buffer) {
                Object t1 = codec1.decode(buffer);
                Object t2 = codec2.decode(buffer);
                Object t3 = codec3.decode(buffer);
                Object t4 = codec4.decode(buffer);
                Object t5 = codec5.decode(buffer);
                Object t6 = codec6.decode(buffer);
                Object t7 = codec7.decode(buffer);
                return factory.apply(t1, t2, t3, t4, t5, t6, t7);
            }

            public void encode(B buffer, C value) {
                codec1.encode(buffer, getter1.apply(value));
                codec2.encode(buffer, getter2.apply(value));
                codec3.encode(buffer, getter3.apply(value));
                codec4.encode(buffer, getter4.apply(value));
                codec5.encode(buffer, getter5.apply(value));
                codec6.encode(buffer, getter6.apply(value));
                codec7.encode(buffer, getter7.apply(value));
            }
        };
    }

    public static <B, C, T1, T2, T3, T4, T5, T6, T7, T8> StreamCodec<B, C> composite(final StreamCodec<? super B, T1> codec1, final Function<C, T1> getter1, final StreamCodec<? super B, T2> codec2, final Function<C, T2> getter2, final StreamCodec<? super B, T3> codec3, final Function<C, T3> getter3, final StreamCodec<? super B, T4> codec4, final Function<C, T4> getter4, final StreamCodec<? super B, T5> codec5, final Function<C, T5> getter5, final StreamCodec<? super B, T6> codec6, final Function<C, T6> getter6, final StreamCodec<? super B, T7> codec7, final Function<C, T7> getter7, final StreamCodec<? super B, T8> codec8, final Function<C, T8> getter8, final Function8<T1, T2, T3, T4, T5, T6, T7, T8, C> factory) {
        return new StreamCodec<B, C>(){

            @NotNull
            public C decode(@NotNull B buffer) {
                Object t1 = codec1.decode(buffer);
                Object t2 = codec2.decode(buffer);
                Object t3 = codec3.decode(buffer);
                Object t4 = codec4.decode(buffer);
                Object t5 = codec5.decode(buffer);
                Object t6 = codec6.decode(buffer);
                Object t7 = codec7.decode(buffer);
                Object t8 = codec8.decode(buffer);
                return factory.apply(t1, t2, t3, t4, t5, t6, t7, t8);
            }

            public void encode(B buffer, C value) {
                codec1.encode(buffer, getter1.apply(value));
                codec2.encode(buffer, getter2.apply(value));
                codec3.encode(buffer, getter3.apply(value));
                codec4.encode(buffer, getter4.apply(value));
                codec5.encode(buffer, getter5.apply(value));
                codec6.encode(buffer, getter6.apply(value));
                codec7.encode(buffer, getter7.apply(value));
                codec8.encode(buffer, getter8.apply(value));
            }
        };
    }

    public static <B, C, T1, T2, T3, T4, T5, T6, T7, T8, T9> StreamCodec<B, C> composite(final StreamCodec<? super B, T1> codec1, final Function<C, T1> getter1, final StreamCodec<? super B, T2> codec2, final Function<C, T2> getter2, final StreamCodec<? super B, T3> codec3, final Function<C, T3> getter3, final StreamCodec<? super B, T4> codec4, final Function<C, T4> getter4, final StreamCodec<? super B, T5> codec5, final Function<C, T5> getter5, final StreamCodec<? super B, T6> codec6, final Function<C, T6> getter6, final StreamCodec<? super B, T7> codec7, final Function<C, T7> getter7, final StreamCodec<? super B, T8> codec8, final Function<C, T8> getter8, final StreamCodec<? super B, T9> codec9, final Function<C, T9> getter9, final Function9<T1, T2, T3, T4, T5, T6, T7, T8, T9, C> factory) {
        return new StreamCodec<B, C>(){

            @NotNull
            public C decode(@NotNull B buffer) {
                Object t1 = codec1.decode(buffer);
                Object t2 = codec2.decode(buffer);
                Object t3 = codec3.decode(buffer);
                Object t4 = codec4.decode(buffer);
                Object t5 = codec5.decode(buffer);
                Object t6 = codec6.decode(buffer);
                Object t7 = codec7.decode(buffer);
                Object t8 = codec8.decode(buffer);
                Object t9 = codec9.decode(buffer);
                return factory.apply(t1, t2, t3, t4, t5, t6, t7, t8, t9);
            }

            public void encode(B buffer, C value) {
                codec1.encode(buffer, getter1.apply(value));
                codec2.encode(buffer, getter2.apply(value));
                codec3.encode(buffer, getter3.apply(value));
                codec4.encode(buffer, getter4.apply(value));
                codec5.encode(buffer, getter5.apply(value));
                codec6.encode(buffer, getter6.apply(value));
                codec7.encode(buffer, getter7.apply(value));
                codec8.encode(buffer, getter8.apply(value));
                codec9.encode(buffer, getter9.apply(value));
            }
        };
    }

    public static <B, C, T1, T2, T3, T4, T5, T6, T7, T8, T9, T10> StreamCodec<B, C> composite(final StreamCodec<? super B, T1> codec1, final Function<C, T1> getter1, final StreamCodec<? super B, T2> codec2, final Function<C, T2> getter2, final StreamCodec<? super B, T3> codec3, final Function<C, T3> getter3, final StreamCodec<? super B, T4> codec4, final Function<C, T4> getter4, final StreamCodec<? super B, T5> codec5, final Function<C, T5> getter5, final StreamCodec<? super B, T6> codec6, final Function<C, T6> getter6, final StreamCodec<? super B, T7> codec7, final Function<C, T7> getter7, final StreamCodec<? super B, T8> codec8, final Function<C, T8> getter8, final StreamCodec<? super B, T9> codec9, final Function<C, T9> getter9, final StreamCodec<? super B, T10> codec10, final Function<C, T10> getter10, final Function10<T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, C> factory) {
        return new StreamCodec<B, C>(){

            @NotNull
            public C decode(@NotNull B buffer) {
                Object t1 = codec1.decode(buffer);
                Object t2 = codec2.decode(buffer);
                Object t3 = codec3.decode(buffer);
                Object t4 = codec4.decode(buffer);
                Object t5 = codec5.decode(buffer);
                Object t6 = codec6.decode(buffer);
                Object t7 = codec7.decode(buffer);
                Object t8 = codec8.decode(buffer);
                Object t9 = codec9.decode(buffer);
                Object t10 = codec10.decode(buffer);
                return factory.apply(t1, t2, t3, t4, t5, t6, t7, t8, t9, t10);
            }

            public void encode(B buffer, C value) {
                codec1.encode(buffer, getter1.apply(value));
                codec2.encode(buffer, getter2.apply(value));
                codec3.encode(buffer, getter3.apply(value));
                codec4.encode(buffer, getter4.apply(value));
                codec5.encode(buffer, getter5.apply(value));
                codec6.encode(buffer, getter6.apply(value));
                codec7.encode(buffer, getter7.apply(value));
                codec8.encode(buffer, getter8.apply(value));
                codec9.encode(buffer, getter9.apply(value));
                codec10.encode(buffer, getter10.apply(value));
            }
        };
    }

    public static <E extends Enum<E>> StreamCodec<ByteBuf, E> enumCodec(E[] elements) {
        return ByteBufCodecs.idMapper(v -> elements[v], Enum::ordinal);
    }

    public static <R> StreamCodec<ByteBuf, TagKey<R>> tagKey(ResourceKey<Registry<R>> key) {
        return ResourceLocation.STREAM_CODEC.map(r -> TagKey.create((ResourceKey)key, (ResourceLocation)r), TagKey::location);
    }

    static <B extends ByteBuf, V, K> StreamCodec.CodecOperation<B, V, Map<K, V>> map(StreamCodec<? super B, K> keyCodec) {
        return p_320272_ -> ByteBufCodecs.map(HashMap::new, (StreamCodec)keyCodec, (StreamCodec)p_320272_);
    }

    public static <B extends ByteBuf, K, V> StreamCodec<B, Multimap<K, V>> multimap(final StreamCodec<? super B, K> keyCodec, final StreamCodec<? super B, V> valueCodec) {
        return new StreamCodec<B, Multimap<K, V>>(){

            public Multimap<K, V> decode(B buffer) {
                int size = buffer.readInt();
                HashMultimap map = HashMultimap.create();
                for (int i = 0; i < size; ++i) {
                    Object key = keyCodec.decode(buffer);
                    int vSize = buffer.readInt();
                    ArrayList<Object> values = new ArrayList<Object>();
                    for (int j = 0; j < vSize; ++j) {
                        values.add(valueCodec.decode(buffer));
                        map.putAll(key, values);
                    }
                }
                return map;
            }

            public void encode(B buffer, Multimap<K, V> value) {
                Set keys = value.keySet();
                buffer.writeInt(keys.size());
                for (Object k : keys) {
                    keyCodec.encode(buffer, k);
                    Collection values = value.get(k);
                    buffer.writeInt(value.size());
                    values.forEach(v -> valueCodec.encode(buffer, v));
                }
            }
        };
    }

    public static <B extends ByteBuf, MK, K, V> StreamCodec<B, DoubleMap<MK, K, V>> doubleMap(final StreamCodec<? super B, MK> key1Codec, final StreamCodec<? super B, K> key2Codec, final StreamCodec<? super B, V> valueCodec) {
        return new StreamCodec<B, DoubleMap<MK, K, V>>(){

            public DoubleMap<MK, K, V> decode(B buffer) {
                int size = buffer.readInt();
                DoubleMap map = new DoubleMap();
                for (int i = 0; i < size; ++i) {
                    Object mk = key1Codec.decode(buffer);
                    int size1 = buffer.readInt();
                    HashMap<Object, Object> entry = new HashMap<Object, Object>();
                    for (int i1 = 0; i1 < size1; ++i1) {
                        entry.put(key2Codec.decode(buffer), valueCodec.decode(buffer));
                    }
                    map.put(mk, entry);
                }
                return map;
            }

            public void encode(B buffer, DoubleMap<MK, K, V> value) {
                Set keys = value.keySet();
                buffer.writeInt(keys.size());
                for (Object key : keys) {
                    key1Codec.encode(buffer, key);
                    Map map = (Map)value.get(key);
                    buffer.writeInt(map.size());
                    map.forEach((k, v) -> {
                        key2Codec.encode(buffer, k);
                        valueCodec.encode(buffer, v);
                    });
                }
            }
        };
    }
}

