/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.helpers;

import com.mojang.serialization.Codec;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.Encoder;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.kapitencraft.kap_lib.KapLibMod;
import net.kapitencraft.kap_lib.client.font.effect.EffectsStyle;
import net.kapitencraft.kap_lib.client.font.effect.GlyphEffect;
import net.kapitencraft.kap_lib.client.particle.DamageIndicatorParticleOptions;
import net.kapitencraft.kap_lib.helpers.ClientHelper;
import net.kapitencraft.kap_lib.helpers.MathHelper;
import net.kapitencraft.kap_lib.helpers.ParticleHelper;
import net.kapitencraft.kap_lib.helpers.TextHelper;
import net.kapitencraft.kap_lib.io.network.S2C.ActivateShakePacket;
import net.kapitencraft.kap_lib.spawn_table.SpawnPool;
import net.kapitencraft.kap_lib.tags.ExtraTags;
import net.kapitencraft.kap_lib.util.Color;
import net.kapitencraft.kap_lib.util.ExtraRarities;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Position;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.PlayerAdvancements;
import net.minecraft.server.ServerAdvancementManager;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.conditions.ConditionalOps;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class MiscHelper {
    public static final String OVERFLOW_MANA_ID = "overflowMana";
    public static final char HEART = '\u2661';
    public static final EquipmentSlot[] ARMOR_EQUIPMENT = (EquipmentSlot[])Arrays.stream(EquipmentSlot.values()).filter(EquipmentSlot::isArmor).toArray(EquipmentSlot[]::new);
    public static final EquipmentSlot[] WEAPON_SLOT = new EquipmentSlot[]{EquipmentSlot.MAINHAND};

    @Contract(value="null, _ -> param2; !null, _ -> param1")
    public static <T> T nonNullOr(@Nullable T value, @NotNull T or) {
        return value == null ? or : value;
    }

    public static void sendManaBoostParticles(Entity target, RandomSource random, Vec3 delta) {
        ClientHelper.sendElytraBoostParticles(target, random, delta, new Color(0.0f, 0.0f, 1.0f, 1.0f), new Color(0.5f, 0.0f, 0.5f, 1.0f));
    }

    public static void swapHands(@NotNull LivingEntity living) {
        ItemStack mainHand = living.getMainHandItem();
        living.setItemInHand(InteractionHand.MAIN_HAND, living.getOffhandItem());
        living.setItemInHand(InteractionHand.OFF_HAND, mainHand);
    }

    public static Style withSpecial(Style style, Supplier<? extends GlyphEffect> effect) {
        return MiscHelper.withSpecial(style, effect.get());
    }

    public static Style withSpecial(Style style, GlyphEffect effect) {
        return EffectsStyle.of(style).addEffect(effect);
    }

    public static boolean is(Item item, TagKey<Item> tagKey) {
        return item.builtInRegistryHolder().is(tagKey);
    }

    @Contract(value="null, _ -> fail; _, null -> fail")
    public static Rarity getFinalRarity(Rarity rarity, ItemStack stack) {
        if (!stack.isEnchanted()) {
            return rarity;
        }
        return switch (rarity) {
            case Rarity.COMMON -> Rarity.UNCOMMON;
            case Rarity.UNCOMMON -> Rarity.RARE;
            case Rarity.RARE -> Rarity.EPIC;
            case Rarity.EPIC -> ExtraRarities.LEGENDARY;
            default -> rarity == ExtraRarities.LEGENDARY ? ExtraRarities.MYTHIC : (rarity == ExtraRarities.MYTHIC ? ExtraRarities.DIVINE : Rarity.COMMON);
        };
    }

    public static <T> T forDifficulty(Difficulty difficulty, T easy, T medium, T hard, T peaceful) {
        return switch (difficulty) {
            default -> throw new MatchException(null, null);
            case Difficulty.EASY -> easy;
            case Difficulty.NORMAL -> medium;
            case Difficulty.HARD -> hard;
            case Difficulty.PEACEFUL -> peaceful;
        };
    }

    public static <T> void ifNonNull(@Nullable T t, Consumer<T> toDo) {
        if (t != null) {
            toDo.accept(t);
        }
    }

    @NotNull
    public static <T, K> K ifNonNullOrDefault(@Nullable T t, Function<T, K> function, Supplier<K> defaulted) {
        if (t != null) {
            return function.apply(t);
        }
        return defaulted.get();
    }

    @Contract(value="_ -> new")
    public static Item.Properties rarity(Rarity rarity) {
        return new Item.Properties().rarity(rarity);
    }

    @Deprecated(forRemoval=true)
    public static boolean awardAchievement(ServerPlayer player, ResourceLocation achievementName) {
        AdvancementProgress progress;
        ServerAdvancementManager manager = player.server.getAdvancements();
        AdvancementHolder adv = manager.get(achievementName);
        PlayerAdvancements advancements = player.getAdvancements();
        if (adv != null && !(progress = advancements.getOrStartProgress(adv)).isDone()) {
            for (String s : progress.getRemainingCriteria()) {
                advancements.award(adv, s);
            }
            return true;
        }
        return false;
    }

    public static <T, K> T getValue(Function<T, K> provider, T defaultValue, K key, T ... values) {
        for (T t : values) {
            if (!provider.apply(t).equals(key)) continue;
            return t;
        }
        return defaultValue;
    }

    public static void schedule(int delayTicks, final Runnable run) {
        new Object(){
            private int ticks = 0;
            private float waitTicks;

            public void start(int waitTicks) {
                this.waitTicks = waitTicks;
                NeoForge.EVENT_BUS.register((Object)this);
            }

            @SubscribeEvent
            public void tick(ServerTickEvent.Post event) {
                ++this.ticks;
                if ((float)this.ticks >= this.waitTicks) {
                    this.end();
                }
            }

            private void end() {
                NeoForge.EVENT_BUS.unregister((Object)this);
                run.run();
            }
        }.start(delayTicks);
    }

    public static boolean saveTeleport(Entity entity, double maxRange) {
        try {
            Vec3 targetPos = entity.getLookAngle().scale(maxRange);
            entity.stopRiding();
            entity.move(MoverType.SELF, targetPos);
        }
        catch (Exception e) {
            KapLibMod.LOGGER.warn("error trying to teleport entity '{}': {}", (Object)entity, (Object)e.getMessage());
            return false;
        }
        return true;
    }

    public static void teleport(Entity entity, Vec3 teleportPosition) {
        entity.teleportTo(teleportPosition.x, teleportPosition.y, teleportPosition.z);
        entity.fallDistance = 0.0f;
        entity.level().playSound(entity, BlockPos.containing((Position)entity.position()), SoundEvents.ENDERMAN_TELEPORT, SoundSource.PLAYERS, 1.0f, 1.0f);
    }

    public static void repeat(int times, Consumer<Integer> consumer) {
        for (int i = 0; i < times; ++i) {
            consumer.accept(i);
        }
    }

    public static MutableComponent buildComponent(MutableComponent ... components) {
        MutableComponent empty = Component.empty();
        for (MutableComponent component : components) {
            empty.append((Component)component);
        }
        return empty;
    }

    @Nullable
    public static LivingEntity getAttacker(@NotNull DamageSource source) {
        LivingEntity living;
        Entity entity = source.getEntity();
        return entity instanceof LivingEntity ? (living = (LivingEntity)entity) : null;
    }

    @Contract(value="null -> fail", pure=true)
    public static DamageType getDamageType(DamageSource source) {
        if (source.is(ExtraTags.DamageTypes.MAGIC)) {
            return DamageType.MAGIC;
        }
        if (source.getEntity() != null) {
            if (source.getDirectEntity() == source.getEntity()) {
                return DamageType.MELEE;
            }
            return DamageType.RANGED;
        }
        return DamageType.MISC;
    }

    public static ArmorStand createMarker(Vec3 pos, Level level, boolean invisible) {
        ArmorStand stand = new ArmorStand(level, pos.x, pos.y, pos.z);
        CompoundTag tag = stand.getPersistentData();
        tag.putBoolean("Marker", true);
        stand.setInvulnerable(true);
        stand.setInvisible(invisible);
        stand.setNoGravity(true);
        stand.setBoundingBox(new AABB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0));
        return stand;
    }

    public static <T> T of(Supplier<T> sup) {
        return sup.get();
    }

    public static void createDamageIndicator(LivingEntity entity, float amount, String type) {
        Level level = entity.level();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            float rangeOffset = entity.getBbHeight() / 2.0f;
            ParticleHelper.sendParticles((Level)serverLevel, new DamageIndicatorParticleOptions(TextHelper.damageIndicatorCoder(type), amount, rangeOffset), false, entity.getX(), entity.getY(), entity.getZ(), 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    @Nullable
    public static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> createTickerHelper(BlockEntityType<A> p_152133_, BlockEntityType<E> p_152134_, BlockEntityTicker<? super E> p_152135_) {
        return p_152134_ == p_152133_ ? p_152135_ : null;
    }

    private static Vec3 getUpdateForPos(Vec3 cam, LivingEntity living) {
        Vec3 livingPos = living.position();
        Vec3 delta = cam.subtract(livingPos);
        return MathHelper.clampLength(delta, 0.5);
    }

    public static ArmorStand createHealthIndicator(LivingEntity target) {
        ArmorStand marker = MiscHelper.createMarker(target.position().add(0.0, 0.5, 0.0), target.level(), true);
        CompoundTag tag = marker.getPersistentData();
        tag.putBoolean("healthMarker", true);
        marker.setCustomName((Component)Component.literal((String)("\u2661 " + target.getHealth() + "/" + target.getMaxHealth())));
        marker.setCustomNameVisible(true);
        target.level().addFreshEntity((Entity)marker);
        return marker;
    }

    public static Rarity getItemRarity(Item item) {
        return (Rarity)item.components().getOrDefault(DataComponents.RARITY, (Object)Rarity.COMMON);
    }

    public static Stream<ItemStack> getArmorEquipment(LivingEntity living) {
        return Arrays.stream(ARMOR_EQUIPMENT).map(arg_0 -> ((LivingEntity)living).getItemBySlot(arg_0));
    }

    public static boolean increaseEffectDuration(LivingEntity living, Holder<MobEffect> effect, int ticks) {
        if (living.hasEffect(effect)) {
            MobEffectInstance oldInstance = living.getEffect(effect);
            assert (oldInstance != null);
            oldInstance.duration += ticks;
            return true;
        }
        return false;
    }

    public static void maxEffectDuration(LivingEntity living, Holder<MobEffect> effect, int minTicks) {
        if (living.hasEffect(effect)) {
            MobEffectInstance oldInstance = living.getEffect(effect);
            assert (oldInstance != null);
            oldInstance.duration = Math.max(oldInstance.duration, minTicks);
        } else {
            living.addEffect(new MobEffectInstance(effect, minTicks));
        }
    }

    public static char[] append(char[] in, char toAppend) {
        char[] copy = new char[in.length + 1];
        MiscHelper.repeat(in.length, integer -> {
            copy[integer.intValue()] = in[integer];
        });
        copy[in.length] = toAppend;
        return copy;
    }

    @Contract(value="_, _, _ -> param1")
    public static List<ItemStack> shrinkDrops(@NotNull List<ItemStack> drops, Item item, int amount) {
        MiscHelper.repeat(drops.size(), i -> {
            ItemStack stack = (ItemStack)drops.get((int)i);
            if (stack.getItem() == item) {
                for (int varAmount = amount; varAmount > 0; --varAmount) {
                    stack.shrink(1);
                    if (!stack.isEmpty()) continue;
                    drops.remove(i);
                    break;
                }
            }
        });
        return drops;
    }

    public static void shakeGround(ServerLevel level, Vec3 pos, float intensity, float strength, float frequency) {
        float radius = strength / intensity;
        List targets = level.getEntitiesOfClass(ServerPlayer.class, new AABB(pos, pos).inflate((double)radius));
        targets.forEach(p -> {
            float dist = Mth.sqrt((float)((float)p.distanceToSqr(pos)));
            PacketDistributor.sendToPlayer((ServerPlayer)p, (CustomPacketPayload)new ActivateShakePacket(intensity, strength * (dist / radius), frequency), (CustomPacketPayload[])new CustomPacketPayload[0]);
        });
    }

    public static Item[] getItemsFromTag(RegistryAccess access, TagKey<Item> tag) {
        return (Item[])((HolderSet.Named)access.registryOrThrow(Registries.ITEM).getTag(tag).orElseThrow(NullPointerException::new)).stream().map(Holder::value).toArray(Item[]::new);
    }

    public static Holder<net.minecraft.world.damagesource.DamageType> lookupDamageTypeHolder(Level level, ResourceKey<net.minecraft.world.damagesource.DamageType> key) {
        return level.registryAccess().registryOrThrow(Registries.DAMAGE_TYPE).getHolderOrThrow(key);
    }

    @ApiStatus.Internal
    public static Codec<List<SpawnPool>> spawnPoolsCodec(BiConsumer<SpawnPool, String> nameSetter) {
        Decoder decoder = ConditionalOps.createConditionalCodec(SpawnPool.CODEC).listOf().map(pools -> {
            if (pools.size() == 1) {
                if (((Optional)pools.getFirst()).isPresent() && ((SpawnPool)((Optional)pools.getFirst()).get()).getName() == null) {
                    nameSetter.accept((SpawnPool)((Optional)pools.getFirst()).get(), "main");
                }
            } else {
                for (int i = 0; i < pools.size(); ++i) {
                    if (!((Optional)pools.get(i)).isPresent() || ((SpawnPool)((Optional)pools.get(i)).get()).getName() != null) continue;
                    nameSetter.accept((SpawnPool)((Optional)pools.get(i)).get(), "pool" + i);
                }
            }
            return pools.stream().filter(Optional::isPresent).map(Optional::get).toList();
        });
        return Codec.of((Encoder)SpawnPool.CODEC.listOf(), (Decoder)decoder);
    }

    public static enum DamageType {
        RANGED,
        MELEE,
        MAGIC,
        MISC;

    }
}

