/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.inventory.page.equipment;

import com.mojang.datafixers.util.Pair;
import java.util.Objects;
import net.kapitencraft.kap_lib.event.custom.WearableSlotChangeEvent;
import net.kapitencraft.kap_lib.inventory.menu.SlotAdder;
import net.kapitencraft.kap_lib.inventory.page.InventoryPage;
import net.kapitencraft.kap_lib.inventory.wearable.IWearable;
import net.kapitencraft.kap_lib.inventory.wearable.WearableSlot;
import net.kapitencraft.kap_lib.inventory.wearable.Wearables;
import net.kapitencraft.kap_lib.registry.vanilla.VanillaInventoryPages;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EquipmentPage
extends InventoryPage {
    private static final ItemStack SYMBOL = new ItemStack((ItemLike)Items.DIAMOND_CHESTPLATE);

    public EquipmentPage(final Player player, SlotAdder adder) {
        super(VanillaInventoryPages.EQUIPMENT.get());
        Wearables wearable = Objects.requireNonNull((Wearables)player.getCapability(Wearables.CAPABILITY), "unable to obtain player wearables!");
        for (int i = 0; i < Wearables.SLOTS.length; ++i) {
            final WearableSlot slot = Wearables.SLOTS[i];
            adder.addSlot(new Slot(this, wearable, i, slot.getXPos(), slot.getYPos()){

                public void setByPlayer(@NotNull ItemStack pStack) {
                    EquipmentPage.equip((LivingEntity)player, slot, pStack, this.getItem());
                    super.setByPlayer(pStack);
                }

                public boolean mayPlace(@NotNull ItemStack pStack) {
                    IWearable wearable;
                    Item item = pStack.getItem();
                    return item instanceof IWearable && (wearable = (IWearable)item).getSlot() == slot;
                }

                public int getMaxStackSize() {
                    return 1;
                }

                @Nullable
                public Pair<ResourceLocation, ResourceLocation> getNoItemIcon() {
                    return slot.getNoItemIcon();
                }
            });
        }
    }

    public static void equip(LivingEntity living, WearableSlot slot, ItemStack newItem, ItemStack oldItem) {
        if (!(oldItem.isEmpty() && newItem.isEmpty() || ItemStack.isSameItemSameComponents((ItemStack)oldItem, (ItemStack)newItem))) {
            IWearable wearable;
            Item item = newItem.getItem();
            if (item instanceof IWearable) {
                wearable = (IWearable)item;
                living.getAttributes().addTransientAttributeModifiers(wearable.getModifiers(slot, newItem));
            }
            if ((item = oldItem.getItem()) instanceof IWearable) {
                wearable = (IWearable)item;
                living.getAttributes().removeAttributeModifiers(wearable.getModifiers(slot, oldItem));
            }
            NeoForge.EVENT_BUS.post((Event)new WearableSlotChangeEvent(living, slot, oldItem, newItem));
        }
    }

    @Override
    @NotNull
    public ItemStack symbol() {
        return SYMBOL;
    }

    @Override
    public boolean withInventory() {
        return true;
    }
}

