/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.spawn_table.functions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.kapitencraft.kap_lib.registry.custom.spawn_table.SpawnEntityFunctions;
import net.kapitencraft.kap_lib.spawn_table.SpawnContext;
import net.kapitencraft.kap_lib.spawn_table.functions.core.SpawnEntityConditionalFunction;
import net.kapitencraft.kap_lib.spawn_table.functions.core.SpawnEntityFunction;
import net.kapitencraft.kap_lib.spawn_table.functions.core.SpawnEntityFunctionType;
import net.minecraft.core.Holder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class AddEffectsFunction
extends SpawnEntityConditionalFunction {
    public static final MapCodec<AddEffectsFunction> CODEC = RecordCodecBuilder.mapCodec(i -> i.group((App)MobEffectInstance.CODEC.listOf().fieldOf("effects").forGetter(f -> f.effects)).and(AddEffectsFunction.commonFields(i).t1()).apply((Applicative)i, AddEffectsFunction::new));
    private final List<MobEffectInstance> effects;

    protected AddEffectsFunction(List<MobEffectInstance> effects, List<LootItemCondition> pPredicates) {
        super(pPredicates);
        this.effects = effects;
    }

    @Override
    protected Entity run(Entity pEntity, SpawnContext pContext) {
        if (pEntity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)pEntity;
            for (MobEffectInstance effect : this.effects) {
                living.addEffect(effect);
            }
        }
        return pEntity;
    }

    @Override
    public SpawnEntityFunctionType getType() {
        return SpawnEntityFunctions.ADD_EFFECTS.get();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends SpawnEntityConditionalFunction.Builder<Builder> {
        private List<MobEffectInstance> effects = new ArrayList<MobEffectInstance>();

        private Builder() {
        }

        public Builder withEffect(MobEffectInstance instance) {
            this.effects.add(instance);
            return this;
        }

        public Builder withEffect(Holder<MobEffect> effect, int duration) {
            return this.withEffect(new MobEffectInstance(effect, duration));
        }

        public Builder withEffect(Holder<MobEffect> effect, int duration, int amplifier) {
            return this.withEffect(new MobEffectInstance(effect, duration, amplifier));
        }

        @Override
        protected Builder getThis() {
            return this;
        }

        @Override
        public SpawnEntityFunction build() {
            return new AddEffectsFunction(this.effects, this.getConditions());
        }
    }
}

