/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.client.widget.menu.drop_down.elements;

import java.util.Arrays;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.kapitencraft.kap_lib.client.widget.menu.IValueModifierElement;
import net.kapitencraft.kap_lib.client.widget.menu.drop_down.DropDownMenu;
import net.kapitencraft.kap_lib.client.widget.menu.drop_down.elements.BooleanElement;
import net.kapitencraft.kap_lib.client.widget.menu.drop_down.elements.Element;
import net.kapitencraft.kap_lib.client.widget.menu.drop_down.elements.ListElement;
import net.minecraft.network.chat.Component;
import org.apache.commons.lang3.Validate;

public class EnumElement<T extends Enum<T>>
extends ListElement
implements IValueModifierElement<EnumElement<T>, T> {
    private T selected;
    private final Function<T, Component> nameMapper;
    private final Consumer<T> onChange;

    public EnumElement(ListElement parent, DropDownMenu menu, Component component, T[] elements, Function<T, Component> nameMapper, Consumer<T> onChange, @Nullable T selected) {
        super(parent, menu, component);
        this.nameMapper = nameMapper;
        this.onChange = onChange;
        Arrays.stream(elements).map(x$0 -> new ListItem(this, x$0)).forEach(this::addElementInternal);
        this.selected = selected;
    }

    private void addElementInternal(Element element) {
        this.children.add(element);
    }

    @Override
    public void addElement(Element element) {
    }

    public EnumElement<T> value(T value) {
        this.selected = value;
        return this;
    }

    @Override
    public void setValue(T value) {
        this.selected = value;
        this.onChange.accept(this.selected);
    }

    public static <T extends Enum<T>> Builder<T> builder(Class<T> ignoredIdentificationClass) {
        return new Builder();
    }

    public static class Builder<T extends Enum<T>>
    extends Element.Builder<EnumElement<T>, Builder<T>> {
        private T[] elements;
        private Function<T, Component> nameMapper;
        private Consumer<T> onChange;
        private T current;

        public Builder<T> setElements(T[] elements) {
            this.elements = elements;
            return this;
        }

        public Builder<T> setOnChange(Consumer<T> onChange) {
            this.onChange = onChange;
            return this;
        }

        public Builder<T> setNameMapper(Function<T, Component> nameMapper) {
            this.nameMapper = nameMapper;
            return this;
        }

        public Builder<T> setCurrent(T current) {
            this.current = current;
            return this;
        }

        @Override
        public EnumElement<T> build(ListElement element, DropDownMenu menu) {
            Validate.notNull(this.elements, (String)"elements may not be null", (Object[])new Object[0]);
            Validate.notNull(this.nameMapper, (String)"nameMapper may not be null", (Object[])new Object[0]);
            Validate.notNull(this.onChange, (String)"onChange may not be null", (Object[])new Object[0]);
            return new EnumElement(element, menu, this.name, this.elements, this.nameMapper, this.onChange, this.current);
        }
    }

    private static class ListItem
    extends BooleanElement {
        private final T id;
        final /* synthetic */ EnumElement this$0;

        protected ListItem(T id) {
            this.this$0 = var1_1;
            super(var1_1, var1_1.menu, var1_1.nameMapper.apply(id), flag -> {
                if (flag.booleanValue()) {
                    var1_1.setValue(id);
                }
            });
            this.id = id;
        }

        @Override
        public boolean selected() {
            return this.this$0.selected == this.id;
        }
    }
}

