/*
 * Decompiled with CFR 0.152.
 */
package net.kapitencraft.kap_lib.event;

import com.google.common.collect.Multimap;
import java.util.Map;
import net.kapitencraft.kap_lib.inventory.wearable.IWearable;
import net.kapitencraft.kap_lib.inventory.wearable.WearableSlot;
import net.kapitencraft.kap_lib.registry.custom.core.ExtraRegistries;
import net.kapitencraft.kap_lib.registry.custom.particle_animation.ActivationTriggers;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.AddAttributeTooltipsEvent;
import net.neoforged.neoforge.common.util.AttributeTooltipContext;
import net.neoforged.neoforge.common.util.AttributeUtil;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import org.spongepowered.asm.mixin.Unique;

@EventBusSubscriber(value={Dist.CLIENT})
public class ClientEvents {
    @SubscribeEvent
    public static void onEntityJoinLevel(EntityJoinLevelEvent event) {
        ActivationTriggers.ENTITY_ADDED.get().trigger(event.getEntity().getId());
    }

    @SubscribeEvent
    public static void onAddAttributeTooltips(AddAttributeTooltipsEvent event) {
        ItemStack stack = event.getStack();
        Item item = stack.getItem();
        if (item instanceof IWearable) {
            IWearable wearable = (IWearable)item;
            for (Map.Entry slotEntry : ExtraRegistries.WEARABLE_SLOTS.entrySet()) {
                Multimap<Holder<Attribute>, AttributeModifier> modifiers = wearable.getModifiers((WearableSlot)slotEntry.getValue(), stack);
                if (modifiers.isEmpty()) continue;
                event.addTooltipLines(new Component[]{CommonComponents.EMPTY, Component.translatable((String)("item.modifiers.wearable." + ClientEvents.getWearableKey((ResourceKey<WearableSlot>)((ResourceKey)slotEntry.getKey())))).withStyle(ChatFormatting.GRAY)});
                AttributeUtil.applyTextFor((ItemStack)stack, xva$0 -> event.addTooltipLines(new Component[]{xva$0}), modifiers, (AttributeTooltipContext)event.getContext());
            }
        }
    }

    @Unique
    private static String getWearableKey(ResourceKey<WearableSlot> key) {
        ResourceLocation location = key.location();
        return location.getNamespace() + "." + location.getPath();
    }
}

